// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class KustoClusterOperationSource : IOperationSource<KustoClusterResource>
    {
        private readonly ArmClient _client;

        internal KustoClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        KustoClusterResource IOperationSource<KustoClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KustoClusterData.DeserializeKustoClusterData(document.RootElement);
            return new KustoClusterResource(_client, data);
        }

        async ValueTask<KustoClusterResource> IOperationSource<KustoClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KustoClusterData.DeserializeKustoClusterData(document.RootElement);
            return new KustoClusterResource(_client, data);
        }
    }
}
