// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class KustoAttachedDatabaseConfigurationOperationSource : IOperationSource<KustoAttachedDatabaseConfigurationResource>
    {
        private readonly ArmClient _client;

        internal KustoAttachedDatabaseConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        KustoAttachedDatabaseConfigurationResource IOperationSource<KustoAttachedDatabaseConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KustoAttachedDatabaseConfigurationData.DeserializeKustoAttachedDatabaseConfigurationData(document.RootElement);
            return new KustoAttachedDatabaseConfigurationResource(_client, data);
        }

        async ValueTask<KustoAttachedDatabaseConfigurationResource> IOperationSource<KustoAttachedDatabaseConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KustoAttachedDatabaseConfigurationData.DeserializeKustoAttachedDatabaseConfigurationData(document.RootElement);
            return new KustoAttachedDatabaseConfigurationResource(_client, data);
        }
    }
}
