// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Kusto.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kusto
{
    /// <summary>
    /// A class representing the KustoScript data model.
    /// Class representing a database script.
    /// </summary>
    public partial class KustoScriptData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoScriptData"/>. </summary>
        public KustoScriptData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KustoScriptData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scriptUri"> The url to the KQL script blob file. Must not be used together with scriptContent property. </param>
        /// <param name="scriptUriSasToken"> The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property. </param>
        /// <param name="scriptContent"> The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties. </param>
        /// <param name="forceUpdateTag"> A unique string. If changed the script will be applied again. </param>
        /// <param name="shouldContinueOnErrors"> Flag that indicates whether to continue if one of the command fails. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoScriptData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, Uri scriptUri, string scriptUriSasToken, string scriptContent, string forceUpdateTag, bool? shouldContinueOnErrors, KustoProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ScriptUri = scriptUri;
            ScriptUriSasToken = scriptUriSasToken;
            ScriptContent = scriptContent;
            ForceUpdateTag = forceUpdateTag;
            ShouldContinueOnErrors = shouldContinueOnErrors;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The url to the KQL script blob file. Must not be used together with scriptContent property. </summary>
        public Uri ScriptUri { get; set; }
        /// <summary> The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property. </summary>
        public string ScriptUriSasToken { get; set; }
        /// <summary> The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties. </summary>
        public string ScriptContent { get; set; }
        /// <summary> A unique string. If changed the script will be applied again. </summary>
        public string ForceUpdateTag { get; set; }
        /// <summary> Flag that indicates whether to continue if one of the command fails. </summary>
        public bool? ShouldContinueOnErrors { get; set; }
        /// <summary> The provisioned state of the resource. </summary>
        public KustoProvisioningState? ProvisioningState { get; }
    }
}
