// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Kusto.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kusto
{
    /// <summary>
    /// A class representing the KustoManagedPrivateEndpoint data model.
    /// Class representing a managed private endpoint.
    /// </summary>
    public partial class KustoManagedPrivateEndpointData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoManagedPrivateEndpointData"/>. </summary>
        public KustoManagedPrivateEndpointData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KustoManagedPrivateEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource for which the managed private endpoint is created. </param>
        /// <param name="privateLinkResourceRegion"> The region of the resource to which the managed private endpoint is created. </param>
        /// <param name="groupId"> The groupId in which the managed private endpoint is created. </param>
        /// <param name="requestMessage"> The user request message. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoManagedPrivateEndpointData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceIdentifier privateLinkResourceId, string privateLinkResourceRegion, string groupId, string requestMessage, KustoProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PrivateLinkResourceId = privateLinkResourceId;
            PrivateLinkResourceRegion = privateLinkResourceRegion;
            GroupId = groupId;
            RequestMessage = requestMessage;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ARM resource ID of the resource for which the managed private endpoint is created. </summary>
        public ResourceIdentifier PrivateLinkResourceId { get; set; }
        /// <summary> The region of the resource to which the managed private endpoint is created. </summary>
        public string PrivateLinkResourceRegion { get; set; }
        /// <summary> The groupId in which the managed private endpoint is created. </summary>
        public string GroupId { get; set; }
        /// <summary> The user request message. </summary>
        public string RequestMessage { get; set; }
        /// <summary> The provisioned state of the resource. </summary>
        public KustoProvisioningState? ProvisioningState { get; }
    }
}
