// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Kusto.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kusto
{
    /// <summary>
    /// A class representing the KustoAttachedDatabaseConfiguration data model.
    /// Class representing an attached database configuration.
    /// </summary>
    public partial class KustoAttachedDatabaseConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoAttachedDatabaseConfigurationData"/>. </summary>
        public KustoAttachedDatabaseConfigurationData()
        {
            AttachedDatabaseNames = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="KustoAttachedDatabaseConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="databaseName"> The name of the database which you would like to attach, use * if you want to follow all current and future databases. </param>
        /// <param name="clusterResourceId"> The resource id of the cluster where the databases you would like to attach reside. </param>
        /// <param name="attachedDatabaseNames"> The list of databases from the clusterResourceId which are currently attached to the cluster. </param>
        /// <param name="defaultPrincipalsModificationKind"> The default principals modification kind. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <param name="databaseNameOverride"> Overrides the original database name. Relevant only when attaching to a specific database. </param>
        /// <param name="databaseNamePrefix"> Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoAttachedDatabaseConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AzureLocation? location, KustoProvisioningState? provisioningState, string databaseName, ResourceIdentifier clusterResourceId, IReadOnlyList<string> attachedDatabaseNames, KustoDatabaseDefaultPrincipalsModificationKind? defaultPrincipalsModificationKind, KustoDatabaseTableLevelSharingProperties tableLevelSharingProperties, string databaseNameOverride, string databaseNamePrefix, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Location = location;
            ProvisioningState = provisioningState;
            DatabaseName = databaseName;
            ClusterResourceId = clusterResourceId;
            AttachedDatabaseNames = attachedDatabaseNames;
            DefaultPrincipalsModificationKind = defaultPrincipalsModificationKind;
            TableLevelSharingProperties = tableLevelSharingProperties;
            DatabaseNameOverride = databaseNameOverride;
            DatabaseNamePrefix = databaseNamePrefix;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource location. </summary>
        public AzureLocation? Location { get; set; }
        /// <summary> The provisioned state of the resource. </summary>
        public KustoProvisioningState? ProvisioningState { get; }
        /// <summary> The name of the database which you would like to attach, use * if you want to follow all current and future databases. </summary>
        public string DatabaseName { get; set; }
        /// <summary> The resource id of the cluster where the databases you would like to attach reside. </summary>
        public ResourceIdentifier ClusterResourceId { get; set; }
        /// <summary> The list of databases from the clusterResourceId which are currently attached to the cluster. </summary>
        public IReadOnlyList<string> AttachedDatabaseNames { get; }
        /// <summary> The default principals modification kind. </summary>
        public KustoDatabaseDefaultPrincipalsModificationKind? DefaultPrincipalsModificationKind { get; set; }
        /// <summary> Table level sharing specifications. </summary>
        public KustoDatabaseTableLevelSharingProperties TableLevelSharingProperties { get; set; }
        /// <summary> Overrides the original database name. Relevant only when attaching to a specific database. </summary>
        public string DatabaseNameOverride { get; set; }
        /// <summary> Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster. </summary>
        public string DatabaseNamePrefix { get; set; }
    }
}
