// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmKustoModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Kusto.KustoClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU of the cluster. </param>
        /// <param name="zones"> The availability zones of the cluster. </param>
        /// <param name="identity"> The identity of the cluster, if configured. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="state"> The state of the resource. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="clusterUri"> The cluster URI. </param>
        /// <param name="dataIngestionUri"> The cluster data ingestion URI. </param>
        /// <param name="stateReason"> The reason for the cluster's current state. </param>
        /// <param name="trustedExternalTenants"> The cluster's external tenants. </param>
        /// <param name="optimizedAutoscale"> Optimized auto scale definition. </param>
        /// <param name="isDiskEncryptionEnabled"> A boolean value that indicates if the cluster's disks are encrypted. </param>
        /// <param name="isStreamingIngestEnabled"> A boolean value that indicates if the streaming ingest is enabled. </param>
        /// <param name="virtualNetworkConfiguration"> Virtual network definition. </param>
        /// <param name="keyVaultProperties"> KeyVault properties for the cluster encryption. </param>
        /// <param name="isPurgeEnabled"> A boolean value that indicates if the purge operations are enabled. </param>
        /// <param name="languageExtensionsValue"> List of the cluster's language extensions. </param>
        /// <param name="isDoubleEncryptionEnabled"> A boolean value that indicates if double encryption is enabled. </param>
        /// <param name="publicNetworkAccess"> Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed. </param>
        /// <param name="allowedIPRangeList"> The list of ips in the format of CIDR allowed to connect to the cluster. </param>
        /// <param name="engineType"> The engine type. </param>
        /// <param name="acceptedAudiences"> The cluster's accepted audiences. </param>
        /// <param name="isAutoStopEnabled"> A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days). </param>
        /// <param name="restrictOutboundNetworkAccess"> Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. </param>
        /// <param name="allowedFqdnList"> List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster. </param>
        /// <param name="publicIPType"> Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). </param>
        /// <param name="virtualClusterGraduationProperties"> Virtual Cluster graduation properties. </param>
        /// <param name="privateEndpointConnections"> A list of private endpoint connections. </param>
        /// <param name="migrationCluster"> Properties of the peer cluster involved in a migration to/from this cluster. </param>
        /// <returns> A new <see cref="Kusto.KustoClusterData"/> instance for mocking. </returns>
        public static KustoClusterData KustoClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, KustoSku sku = null, IEnumerable<string> zones = null, ManagedServiceIdentity identity = null, ETag? etag = null, KustoClusterState? state = null, KustoProvisioningState? provisioningState = null, Uri clusterUri = null, Uri dataIngestionUri = null, string stateReason = null, IEnumerable<KustoClusterTrustedExternalTenant> trustedExternalTenants = null, OptimizedAutoscale optimizedAutoscale = null, bool? isDiskEncryptionEnabled = null, bool? isStreamingIngestEnabled = null, KustoClusterVirtualNetworkConfiguration virtualNetworkConfiguration = null, KustoKeyVaultProperties keyVaultProperties = null, bool? isPurgeEnabled = null, IEnumerable<KustoLanguageExtension> languageExtensionsValue = null, bool? isDoubleEncryptionEnabled = null, KustoClusterPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<string> allowedIPRangeList = null, KustoClusterEngineType? engineType = null, IEnumerable<AcceptedAudience> acceptedAudiences = null, bool? isAutoStopEnabled = null, KustoClusterNetworkAccessFlag? restrictOutboundNetworkAccess = null, IEnumerable<string> allowedFqdnList = null, KustoClusterPublicIPType? publicIPType = null, string virtualClusterGraduationProperties = null, IEnumerable<KustoPrivateEndpointConnectionData> privateEndpointConnections = null, MigrationClusterProperties migrationCluster = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            trustedExternalTenants ??= new List<KustoClusterTrustedExternalTenant>();
            languageExtensionsValue ??= new List<KustoLanguageExtension>();
            allowedIPRangeList ??= new List<string>();
            acceptedAudiences ??= new List<AcceptedAudience>();
            allowedFqdnList ??= new List<string>();
            privateEndpointConnections ??= new List<KustoPrivateEndpointConnectionData>();

            return new KustoClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                zones?.ToList(),
                identity,
                etag,
                state,
                provisioningState,
                clusterUri,
                dataIngestionUri,
                stateReason,
                trustedExternalTenants?.ToList(),
                optimizedAutoscale,
                isDiskEncryptionEnabled,
                isStreamingIngestEnabled,
                virtualNetworkConfiguration,
                keyVaultProperties,
                isPurgeEnabled,
                languageExtensionsValue != null ? new KustoLanguageExtensionList(languageExtensionsValue?.ToList(), serializedAdditionalRawData: null) : null,
                isDoubleEncryptionEnabled,
                publicNetworkAccess,
                allowedIPRangeList?.ToList(),
                engineType,
                acceptedAudiences?.ToList(),
                isAutoStopEnabled,
                restrictOutboundNetworkAccess,
                allowedFqdnList?.ToList(),
                publicIPType,
                virtualClusterGraduationProperties,
                privateEndpointConnections?.ToList(),
                migrationCluster,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> Private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection State of the Private Endpoint Connection. </param>
        /// <param name="groupId"> Group id of the private endpoint. </param>
        /// <param name="provisioningState"> Provisioning state of the private endpoint. </param>
        /// <returns> A new <see cref="Kusto.KustoPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static KustoPrivateEndpointConnectionData KustoPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, KustoPrivateLinkServiceConnectionStateProperty connectionState = null, string groupId = null, string provisioningState = null)
        {
            return new KustoPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                groupId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoPrivateLinkServiceConnectionStateProperty"/>. </summary>
        /// <param name="status"> The private link service connection status. </param>
        /// <param name="description"> The private link service connection description. </param>
        /// <param name="actionsRequired"> Any action that is required beyond basic workflow (approve/ reject/ disconnect). </param>
        /// <returns> A new <see cref="Models.KustoPrivateLinkServiceConnectionStateProperty"/> instance for mocking. </returns>
        public static KustoPrivateLinkServiceConnectionStateProperty KustoPrivateLinkServiceConnectionStateProperty(string status = null, string description = null, string actionsRequired = null)
        {
            return new KustoPrivateLinkServiceConnectionStateProperty(status, description, actionsRequired, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationClusterProperties"/>. </summary>
        /// <param name="id"> The resource ID of the cluster. </param>
        /// <param name="uri"> The public URL of the cluster. </param>
        /// <param name="dataIngestionUri"> The public data ingestion URL of the cluster. </param>
        /// <param name="role"> The role of the cluster in the migration process. </param>
        /// <returns> A new <see cref="Models.MigrationClusterProperties"/> instance for mocking. </returns>
        public static MigrationClusterProperties MigrationClusterProperties(string id = null, Uri uri = null, Uri dataIngestionUri = null, MigrationClusterRole? role = null)
        {
            return new MigrationClusterProperties(id, uri, dataIngestionUri, role, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoClusterPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU of the cluster. </param>
        /// <param name="zones"> The availability zones of the cluster. </param>
        /// <param name="identity"> The identity of the cluster, if configured. </param>
        /// <param name="state"> The state of the resource. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="uri"> The cluster URI. </param>
        /// <param name="dataIngestionUri"> The cluster data ingestion URI. </param>
        /// <param name="stateReason"> The reason for the cluster's current state. </param>
        /// <param name="trustedExternalTenants"> The cluster's external tenants. </param>
        /// <param name="optimizedAutoscale"> Optimized auto scale definition. </param>
        /// <param name="isDiskEncryptionEnabled"> A boolean value that indicates if the cluster's disks are encrypted. </param>
        /// <param name="isStreamingIngestEnabled"> A boolean value that indicates if the streaming ingest is enabled. </param>
        /// <param name="virtualNetworkConfiguration"> Virtual network definition. </param>
        /// <param name="keyVaultProperties"> KeyVault properties for the cluster encryption. </param>
        /// <param name="isPurgeEnabled"> A boolean value that indicates if the purge operations are enabled. </param>
        /// <param name="languageExtensionsValue"> List of the cluster's language extensions. </param>
        /// <param name="isDoubleEncryptionEnabled"> A boolean value that indicates if double encryption is enabled. </param>
        /// <param name="publicNetworkAccess"> Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed. </param>
        /// <param name="allowedIPRangeList"> The list of ips in the format of CIDR allowed to connect to the cluster. </param>
        /// <param name="engineType"> The engine type. </param>
        /// <param name="acceptedAudiences"> The cluster's accepted audiences. </param>
        /// <param name="isAutoStopEnabled"> A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days). </param>
        /// <param name="restrictOutboundNetworkAccess"> Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. </param>
        /// <param name="allowedFqdnList"> List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster. </param>
        /// <param name="publicIPType"> Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). </param>
        /// <param name="virtualClusterGraduationProperties"> Virtual Cluster graduation properties. </param>
        /// <param name="privateEndpointConnections"> A list of private endpoint connections. </param>
        /// <param name="migrationCluster"> Properties of the peer cluster involved in a migration to/from this cluster. </param>
        /// <returns> A new <see cref="Models.KustoClusterPatch"/> instance for mocking. </returns>
        public static KustoClusterPatch KustoClusterPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, KustoSku sku = null, IEnumerable<string> zones = null, ManagedServiceIdentity identity = null, KustoClusterState? state = null, KustoProvisioningState? provisioningState = null, Uri uri = null, Uri dataIngestionUri = null, string stateReason = null, IEnumerable<KustoClusterTrustedExternalTenant> trustedExternalTenants = null, OptimizedAutoscale optimizedAutoscale = null, bool? isDiskEncryptionEnabled = null, bool? isStreamingIngestEnabled = null, KustoClusterVirtualNetworkConfiguration virtualNetworkConfiguration = null, KustoKeyVaultProperties keyVaultProperties = null, bool? isPurgeEnabled = null, IEnumerable<KustoLanguageExtension> languageExtensionsValue = null, bool? isDoubleEncryptionEnabled = null, KustoClusterPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<string> allowedIPRangeList = null, KustoClusterEngineType? engineType = null, IEnumerable<AcceptedAudience> acceptedAudiences = null, bool? isAutoStopEnabled = null, KustoClusterNetworkAccessFlag? restrictOutboundNetworkAccess = null, IEnumerable<string> allowedFqdnList = null, KustoClusterPublicIPType? publicIPType = null, string virtualClusterGraduationProperties = null, IEnumerable<KustoPrivateEndpointConnectionData> privateEndpointConnections = null, MigrationClusterProperties migrationCluster = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();
            trustedExternalTenants ??= new List<KustoClusterTrustedExternalTenant>();
            languageExtensionsValue ??= new List<KustoLanguageExtension>();
            allowedIPRangeList ??= new List<string>();
            acceptedAudiences ??= new List<AcceptedAudience>();
            allowedFqdnList ??= new List<string>();
            privateEndpointConnections ??= new List<KustoPrivateEndpointConnectionData>();

            return new KustoClusterPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                zones?.ToList(),
                identity,
                state,
                provisioningState,
                uri,
                dataIngestionUri,
                stateReason,
                trustedExternalTenants?.ToList(),
                optimizedAutoscale,
                isDiskEncryptionEnabled,
                isStreamingIngestEnabled,
                virtualNetworkConfiguration,
                keyVaultProperties,
                isPurgeEnabled,
                languageExtensionsValue != null ? new KustoLanguageExtensionList(languageExtensionsValue?.ToList(), serializedAdditionalRawData: null) : null,
                isDoubleEncryptionEnabled,
                publicNetworkAccess,
                allowedIPRangeList?.ToList(),
                engineType,
                acceptedAudiences?.ToList(),
                isAutoStopEnabled,
                restrictOutboundNetworkAccess,
                allowedFqdnList?.ToList(),
                publicIPType,
                virtualClusterGraduationProperties,
                privateEndpointConnections?.ToList(),
                migrationCluster,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoClusterPrincipalAssignmentNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Principal Assignment resource name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Kusto/clusters/principalAssignments. </param>
        /// <returns> A new <see cref="Models.KustoClusterPrincipalAssignmentNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoClusterPrincipalAssignmentNameAvailabilityContent KustoClusterPrincipalAssignmentNameAvailabilityContent(string name = null, KustoClusterPrincipalAssignmentType resourceType = default)
        {
            return new KustoClusterPrincipalAssignmentNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoNameAvailabilityResult"/>. </summary>
        /// <param name="nameAvailable"> Specifies a Boolean value that indicates if the name is available. </param>
        /// <param name="name"> The name that was checked. </param>
        /// <param name="message"> Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated. </param>
        /// <param name="reason"> Message providing the reason why the given name is invalid. </param>
        /// <returns> A new <see cref="Models.KustoNameAvailabilityResult"/> instance for mocking. </returns>
        public static KustoNameAvailabilityResult KustoNameAvailabilityResult(bool? nameAvailable = null, string name = null, string message = null, KustoNameUnavailableReason? reason = null)
        {
            return new KustoNameAvailabilityResult(nameAvailable, name, message, reason, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoClusterPrincipalAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="clusterPrincipalId"> The principal ID assigned to the cluster principal. It can be a user email, application ID, or security group name. </param>
        /// <param name="role"> Cluster principal role. </param>
        /// <param name="tenantId"> The tenant id of the principal. </param>
        /// <param name="principalType"> Principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <param name="principalName"> The principal name. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="aadObjectId"> The service principal object id in AAD (Azure active directory). </param>
        /// <returns> A new <see cref="Kusto.KustoClusterPrincipalAssignmentData"/> instance for mocking. </returns>
        public static KustoClusterPrincipalAssignmentData KustoClusterPrincipalAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string clusterPrincipalId = null, KustoClusterPrincipalRole? role = null, Guid? tenantId = null, KustoPrincipalAssignmentType? principalType = null, string tenantName = null, string principalName = null, KustoProvisioningState? provisioningState = null, Guid? aadObjectId = null)
        {
            return new KustoClusterPrincipalAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                clusterPrincipalId,
                role,
                tenantId,
                principalType,
                tenantName,
                principalName,
                provisioningState,
                aadObjectId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoFollowerDatabaseDefinition"/>. </summary>
        /// <param name="clusterResourceId"> Resource id of the cluster that follows a database owned by this cluster. </param>
        /// <param name="attachedDatabaseConfigurationName"> Resource name of the attached database configuration in the follower cluster. </param>
        /// <param name="databaseName"> The database name owned by this cluster that was followed. * in case following all databases. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <param name="databaseShareOrigin"> The origin of the following setup. </param>
        /// <returns> A new <see cref="Models.KustoFollowerDatabaseDefinition"/> instance for mocking. </returns>
        public static KustoFollowerDatabaseDefinition KustoFollowerDatabaseDefinition(ResourceIdentifier clusterResourceId = null, string attachedDatabaseConfigurationName = null, string databaseName = null, KustoDatabaseTableLevelSharingProperties tableLevelSharingProperties = null, KustoDatabaseShareOrigin? databaseShareOrigin = null)
        {
            return new KustoFollowerDatabaseDefinition(
                clusterResourceId,
                attachedDatabaseConfigurationName,
                databaseName,
                tableLevelSharingProperties,
                databaseShareOrigin,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DiagnoseVirtualNetworkResult"/>. </summary>
        /// <param name="findings"> The list of network connectivity diagnostic finding. </param>
        /// <returns> A new <see cref="Models.DiagnoseVirtualNetworkResult"/> instance for mocking. </returns>
        public static DiagnoseVirtualNetworkResult DiagnoseVirtualNetworkResult(IEnumerable<string> findings = null)
        {
            findings ??= new List<string>();

            return new DiagnoseVirtualNetworkResult(findings?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoSkuDescription"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="name"> The name of the SKU. </param>
        /// <param name="tier"> The tier of the SKU. </param>
        /// <param name="locations"> The set of locations that the SKU is available. </param>
        /// <param name="locationInfo"> Locations and zones. </param>
        /// <param name="restrictions"> The restrictions because of which SKU cannot be used. </param>
        /// <returns> A new <see cref="Models.KustoSkuDescription"/> instance for mocking. </returns>
        public static KustoSkuDescription KustoSkuDescription(string resourceType = null, string name = null, string tier = null, IEnumerable<AzureLocation> locations = null, IEnumerable<KustoSkuLocationInfoItem> locationInfo = null, IEnumerable<BinaryData> restrictions = null)
        {
            locations ??= new List<AzureLocation>();
            locationInfo ??= new List<KustoSkuLocationInfoItem>();
            restrictions ??= new List<BinaryData>();

            return new KustoSkuDescription(
                resourceType,
                name,
                tier,
                locations?.ToList(),
                locationInfo?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoSkuLocationInfoItem"/>. </summary>
        /// <param name="location"> The available location of the SKU. </param>
        /// <param name="zones"> The available zone of the SKU. </param>
        /// <param name="zoneDetails"> Gets details of capabilities available to a SKU in specific zones. </param>
        /// <returns> A new <see cref="Models.KustoSkuLocationInfoItem"/> instance for mocking. </returns>
        public static KustoSkuLocationInfoItem KustoSkuLocationInfoItem(AzureLocation location = default, IEnumerable<string> zones = null, IEnumerable<KustoResourceSkuZoneDetails> zoneDetails = null)
        {
            zones ??= new List<string>();
            zoneDetails ??= new List<KustoResourceSkuZoneDetails>();

            return new KustoSkuLocationInfoItem(location, zones?.ToList(), zoneDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoResourceSkuZoneDetails"/>. </summary>
        /// <param name="name"> The set of zones that the SKU is available in with the specified capabilities. </param>
        /// <param name="capabilities"> A list of capabilities that are available for the SKU in the specified list of zones. </param>
        /// <returns> A new <see cref="Models.KustoResourceSkuZoneDetails"/> instance for mocking. </returns>
        public static KustoResourceSkuZoneDetails KustoResourceSkuZoneDetails(IEnumerable<string> name = null, IEnumerable<KustoResourceSkuCapabilities> capabilities = null)
        {
            name ??= new List<string>();
            capabilities ??= new List<KustoResourceSkuCapabilities>();

            return new KustoResourceSkuZoneDetails(name?.ToList(), capabilities?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoResourceSkuCapabilities"/>. </summary>
        /// <param name="name"> An invariant to describe the feature. </param>
        /// <param name="value"> An invariant if the feature is measured by quantity. </param>
        /// <returns> A new <see cref="Models.KustoResourceSkuCapabilities"/> instance for mocking. </returns>
        public static KustoResourceSkuCapabilities KustoResourceSkuCapabilities(string name = null, string value = null)
        {
            return new KustoResourceSkuCapabilities(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoClusterNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Cluster name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Kusto/clusters. </param>
        /// <returns> A new <see cref="Models.KustoClusterNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoClusterNameAvailabilityContent KustoClusterNameAvailabilityContent(string name = null, KustoClusterType resourceType = default)
        {
            return new KustoClusterNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoAttachedDatabaseConfigurationNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Attached database resource name. </param>
        /// <param name="resourceType"> The type of resource, for instance Microsoft.Kusto/clusters/attachedDatabaseConfigurations. </param>
        /// <returns> A new <see cref="Models.KustoAttachedDatabaseConfigurationNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoAttachedDatabaseConfigurationNameAvailabilityContent KustoAttachedDatabaseConfigurationNameAvailabilityContent(string name = null, AttachedDatabaseType resourceType = default)
        {
            return new KustoAttachedDatabaseConfigurationNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoManagedPrivateEndpointNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Managed private endpoint resource name. </param>
        /// <param name="resourceType"> The type of resource, for instance Microsoft.Kusto/clusters/managedPrivateEndpoints. </param>
        /// <returns> A new <see cref="Models.KustoManagedPrivateEndpointNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoManagedPrivateEndpointNameAvailabilityContent KustoManagedPrivateEndpointNameAvailabilityContent(string name = null, KustoManagedPrivateEndpointsType resourceType = default)
        {
            return new KustoManagedPrivateEndpointNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoAvailableSkuDetails"/>. </summary>
        /// <param name="resourceType"> Resource Namespace and Type. </param>
        /// <param name="sku"> The SKU details. </param>
        /// <param name="capacity"> The number of instances of the cluster. </param>
        /// <returns> A new <see cref="Models.KustoAvailableSkuDetails"/> instance for mocking. </returns>
        public static KustoAvailableSkuDetails KustoAvailableSkuDetails(string resourceType = null, KustoSku sku = null, KustoCapacity capacity = null)
        {
            return new KustoAvailableSkuDetails(resourceType, sku, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoCapacity"/>. </summary>
        /// <param name="scaleType"> Scale type. </param>
        /// <param name="minimum"> Minimum allowed capacity. </param>
        /// <param name="maximum"> Maximum allowed capacity. </param>
        /// <param name="default"> The default capacity that would be used. </param>
        /// <returns> A new <see cref="Models.KustoCapacity"/> instance for mocking. </returns>
        public static KustoCapacity KustoCapacity(KustoScaleType scaleType = default, int minimum = default, int maximum = default, int @default = default)
        {
            return new KustoCapacity(scaleType, minimum, maximum, @default, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="kind"> Kind of the database. </param>
        /// <returns> A new <see cref="Kusto.KustoDatabaseData"/> instance for mocking. </returns>
        public static KustoDatabaseData KustoDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null)
        {
            return new KustoDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind == null ? default : new KustoKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseInviteFollowerContent"/>. </summary>
        /// <param name="inviteeEmail"> The email of the invited user for which the follower invitation is generated. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <returns> A new <see cref="Models.DatabaseInviteFollowerContent"/> instance for mocking. </returns>
        public static DatabaseInviteFollowerContent DatabaseInviteFollowerContent(string inviteeEmail = null, KustoDatabaseTableLevelSharingProperties tableLevelSharingProperties = null)
        {
            return new DatabaseInviteFollowerContent(inviteeEmail, tableLevelSharingProperties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseInviteFollowerResult"/>. </summary>
        /// <param name="generatedInvitation"> The generated invitation token. </param>
        /// <returns> A new <see cref="Models.DatabaseInviteFollowerResult"/> instance for mocking. </returns>
        public static DatabaseInviteFollowerResult DatabaseInviteFollowerResult(string generatedInvitation = null)
        {
            return new DatabaseInviteFollowerResult(generatedInvitation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoDatabasePrincipalAssignmentNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Principal Assignment resource name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Kusto/clusters/databases/principalAssignments. </param>
        /// <returns> A new <see cref="Models.KustoDatabasePrincipalAssignmentNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoDatabasePrincipalAssignmentNameAvailabilityContent KustoDatabasePrincipalAssignmentNameAvailabilityContent(string name = null, KustoDatabasePrincipalAssignmentType resourceType = default)
        {
            return new KustoDatabasePrincipalAssignmentNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoDatabasePrincipalAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databasePrincipalId"> The principal ID assigned to the database principal. It can be a user email, application ID, or security group name. </param>
        /// <param name="role"> Database principal role. </param>
        /// <param name="tenantId"> The tenant id of the principal. </param>
        /// <param name="principalType"> Principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <param name="principalName"> The principal name. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="aadObjectId"> The service principal object id in AAD (Azure active directory). </param>
        /// <returns> A new <see cref="Kusto.KustoDatabasePrincipalAssignmentData"/> instance for mocking. </returns>
        public static KustoDatabasePrincipalAssignmentData KustoDatabasePrincipalAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databasePrincipalId = null, KustoDatabasePrincipalRole? role = null, Guid? tenantId = null, KustoPrincipalAssignmentType? principalType = null, string tenantName = null, string principalName = null, KustoProvisioningState? provisioningState = null, Guid? aadObjectId = null)
        {
            return new KustoDatabasePrincipalAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                databasePrincipalId,
                role,
                tenantId,
                principalType,
                tenantName,
                principalName,
                provisioningState,
                aadObjectId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoDatabasePrincipal"/>. </summary>
        /// <param name="role"> Database principal role. </param>
        /// <param name="name"> Database principal name. </param>
        /// <param name="principalType"> Database principal type. </param>
        /// <param name="fqn"> Database principal fully qualified name. </param>
        /// <param name="email"> Database principal email if exists. </param>
        /// <param name="appId"> Application id - relevant only for application principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <returns> A new <see cref="Models.KustoDatabasePrincipal"/> instance for mocking. </returns>
        public static KustoDatabasePrincipal KustoDatabasePrincipal(KustoDatabasePrincipalRole role = default, string name = null, KustoDatabasePrincipalType principalType = default, string fqn = null, string email = null, string appId = null, string tenantName = null)
        {
            return new KustoDatabasePrincipal(
                role,
                name,
                principalType,
                fqn,
                email,
                appId,
                tenantName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoScriptData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scriptUri"> The url to the KQL script blob file. Must not be used together with scriptContent property. </param>
        /// <param name="scriptUriSasToken"> The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property. </param>
        /// <param name="scriptContent"> The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties. </param>
        /// <param name="forceUpdateTag"> A unique string. If changed the script will be applied again. </param>
        /// <param name="shouldContinueOnErrors"> Flag that indicates whether to continue if one of the command fails. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Kusto.KustoScriptData"/> instance for mocking. </returns>
        public static KustoScriptData KustoScriptData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Uri scriptUri = null, string scriptUriSasToken = null, string scriptContent = null, string forceUpdateTag = null, bool? shouldContinueOnErrors = null, KustoProvisioningState? provisioningState = null)
        {
            return new KustoScriptData(
                id,
                name,
                resourceType,
                systemData,
                scriptUri,
                scriptUriSasToken,
                scriptContent,
                forceUpdateTag,
                shouldContinueOnErrors,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.SandboxCustomImageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="language"> The language name, for example Python. </param>
        /// <param name="languageVersion"> The version of the language. </param>
        /// <param name="requirementsFileContent"> The requirements file content. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Kusto.SandboxCustomImageData"/> instance for mocking. </returns>
        public static SandboxCustomImageData SandboxCustomImageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SandboxCustomImageLanguage? language = null, string languageVersion = null, string requirementsFileContent = null, KustoProvisioningState? provisioningState = null)
        {
            return new SandboxCustomImageData(
                id,
                name,
                resourceType,
                systemData,
                language,
                languageVersion,
                requirementsFileContent,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SandboxCustomImagesCheckNameContent"/>. </summary>
        /// <param name="name"> Sandbox custom image resource name. </param>
        /// <param name="imageType"> The type of resource, for instance Microsoft.Kusto/clusters/sandboxCustomImages. </param>
        /// <returns> A new <see cref="Models.SandboxCustomImagesCheckNameContent"/> instance for mocking. </returns>
        public static SandboxCustomImagesCheckNameContent SandboxCustomImagesCheckNameContent(string name = null, SandboxCustomImageType imageType = default)
        {
            return new SandboxCustomImagesCheckNameContent(name, imageType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoManagedPrivateEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource for which the managed private endpoint is created. </param>
        /// <param name="privateLinkResourceRegion"> The region of the resource to which the managed private endpoint is created. </param>
        /// <param name="groupId"> The groupId in which the managed private endpoint is created. </param>
        /// <param name="requestMessage"> The user request message. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Kusto.KustoManagedPrivateEndpointData"/> instance for mocking. </returns>
        public static KustoManagedPrivateEndpointData KustoManagedPrivateEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateLinkResourceId = null, string privateLinkResourceRegion = null, string groupId = null, string requestMessage = null, KustoProvisioningState? provisioningState = null)
        {
            return new KustoManagedPrivateEndpointData(
                id,
                name,
                resourceType,
                systemData,
                privateLinkResourceId,
                privateLinkResourceRegion,
                groupId,
                requestMessage,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource required zone names. </param>
        /// <returns> A new <see cref="Kusto.KustoPrivateLinkResourceData"/> instance for mocking. </returns>
        public static KustoPrivateLinkResourceData KustoPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new KustoPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OutboundNetworkDependenciesEndpoint"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="category"> The type of service accessed by the Kusto Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active Directory. </param>
        /// <param name="endpoints"> The endpoints that the Kusto Service Environment reaches the service at. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.OutboundNetworkDependenciesEndpoint"/> instance for mocking. </returns>
        public static OutboundNetworkDependenciesEndpoint OutboundNetworkDependenciesEndpoint(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string category = null, IEnumerable<EndpointDependency> endpoints = null, KustoProvisioningState? provisioningState = null)
        {
            endpoints ??= new List<EndpointDependency>();

            return new OutboundNetworkDependenciesEndpoint(
                id,
                name,
                resourceType,
                systemData,
                etag,
                category,
                endpoints?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoAttachedDatabaseConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="databaseName"> The name of the database which you would like to attach, use * if you want to follow all current and future databases. </param>
        /// <param name="clusterResourceId"> The resource id of the cluster where the databases you would like to attach reside. </param>
        /// <param name="attachedDatabaseNames"> The list of databases from the clusterResourceId which are currently attached to the cluster. </param>
        /// <param name="defaultPrincipalsModificationKind"> The default principals modification kind. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <param name="databaseNameOverride"> Overrides the original database name. Relevant only when attaching to a specific database. </param>
        /// <param name="databaseNamePrefix"> Adds a prefix to the attached databases name. When following an entire cluster, that prefix would be added to all of the databases original names from leader cluster. </param>
        /// <returns> A new <see cref="Kusto.KustoAttachedDatabaseConfigurationData"/> instance for mocking. </returns>
        public static KustoAttachedDatabaseConfigurationData KustoAttachedDatabaseConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, KustoProvisioningState? provisioningState = null, string databaseName = null, ResourceIdentifier clusterResourceId = null, IEnumerable<string> attachedDatabaseNames = null, KustoDatabaseDefaultPrincipalsModificationKind? defaultPrincipalsModificationKind = null, KustoDatabaseTableLevelSharingProperties tableLevelSharingProperties = null, string databaseNameOverride = null, string databaseNamePrefix = null)
        {
            attachedDatabaseNames ??= new List<string>();

            return new KustoAttachedDatabaseConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                location,
                provisioningState,
                databaseName,
                clusterResourceId,
                attachedDatabaseNames?.ToList(),
                defaultPrincipalsModificationKind,
                tableLevelSharingProperties,
                databaseNameOverride,
                databaseNamePrefix,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Kusto.KustoDataConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="kind"> Kind of the endpoint for the data connection. </param>
        /// <returns> A new <see cref="Kusto.KustoDataConnectionData"/> instance for mocking. </returns>
        public static KustoDataConnectionData KustoDataConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string kind = null)
        {
            return new KustoDataConnectionData(
                id,
                name,
                resourceType,
                systemData,
                location,
                kind == null ? default : new DataConnectionKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataConnectionValidationResults"/>. </summary>
        /// <param name="value"> The list of Kusto data connection validation errors. </param>
        /// <returns> A new <see cref="Models.DataConnectionValidationResults"/> instance for mocking. </returns>
        public static DataConnectionValidationResults DataConnectionValidationResults(IEnumerable<DataConnectionValidationResult> value = null)
        {
            value ??= new List<DataConnectionValidationResult>();

            return new DataConnectionValidationResults(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataConnectionValidationResult"/>. </summary>
        /// <param name="errorMessage"> A message which indicates a problem in data connection validation. </param>
        /// <returns> A new <see cref="Models.DataConnectionValidationResult"/> instance for mocking. </returns>
        public static DataConnectionValidationResult DataConnectionValidationResult(string errorMessage = null)
        {
            return new DataConnectionValidationResult(errorMessage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoDataConnectionNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Data Connection name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Kusto/clusters/databases/dataConnections. </param>
        /// <returns> A new <see cref="Models.KustoDataConnectionNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoDataConnectionNameAvailabilityContent KustoDataConnectionNameAvailabilityContent(string name = null, KustoDataConnectionType resourceType = default)
        {
            return new KustoDataConnectionNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoScriptNameAvailabilityContent"/>. </summary>
        /// <param name="name"> Script name. </param>
        /// <param name="resourceType"> The type of resource, Microsoft.Kusto/clusters/databases/scripts. </param>
        /// <returns> A new <see cref="Models.KustoScriptNameAvailabilityContent"/> instance for mocking. </returns>
        public static KustoScriptNameAvailabilityContent KustoScriptNameAvailabilityContent(string name = null, KustoScriptType resourceType = default)
        {
            return new KustoScriptNameAvailabilityContent(name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoReadWriteDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="softDeletePeriod"> The time the data should be kept before it stops being accessible to queries in TimeSpan. </param>
        /// <param name="hotCachePeriod"> The time the data should be kept in cache for fast queries in TimeSpan. </param>
        /// <param name="statisticsSize"> The statistics of the database. </param>
        /// <param name="isFollowed"> Indicates whether the database is followed. </param>
        /// <param name="keyVaultProperties"> KeyVault properties for the database encryption. </param>
        /// <param name="suspensionStartOn"> The database suspension details. If the database is suspended, this object contains information related to the database's suspension state. </param>
        /// <returns> A new <see cref="Models.KustoReadWriteDatabase"/> instance for mocking. </returns>
        public static KustoReadWriteDatabase KustoReadWriteDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, KustoProvisioningState? provisioningState = null, TimeSpan? softDeletePeriod = null, TimeSpan? hotCachePeriod = null, float? statisticsSize = null, bool? isFollowed = null, KustoKeyVaultProperties keyVaultProperties = null, DateTimeOffset? suspensionStartOn = null)
        {
            return new KustoReadWriteDatabase(
                id,
                name,
                resourceType,
                systemData,
                location,
                KustoKind.ReadWrite,
                serializedAdditionalRawData: null,
                provisioningState,
                softDeletePeriod,
                hotCachePeriod,
                statisticsSize != null ? new DatabaseStatistics(statisticsSize, serializedAdditionalRawData: null) : null,
                isFollowed,
                keyVaultProperties,
                suspensionStartOn != null ? new SuspensionDetails(suspensionStartOn, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoReadOnlyFollowingDatabase"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="softDeletePeriod"> The time the data should be kept before it stops being accessible to queries in TimeSpan. </param>
        /// <param name="hotCachePeriod"> The time the data should be kept in cache for fast queries in TimeSpan. </param>
        /// <param name="statisticsSize"> The statistics of the database. </param>
        /// <param name="leaderClusterResourceId"> The name of the leader cluster. </param>
        /// <param name="attachedDatabaseConfigurationName"> The name of the attached database configuration cluster. </param>
        /// <param name="principalsModificationKind"> The principals modification kind of the database. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing specifications. </param>
        /// <param name="originalDatabaseName"> The original database name, before databaseNameOverride or databaseNamePrefix where applied. </param>
        /// <param name="databaseShareOrigin"> The origin of the following setup. </param>
        /// <param name="suspensionStartOn"> The database suspension details. If the database is suspended, this object contains information related to the database's suspension state. </param>
        /// <returns> A new <see cref="Models.KustoReadOnlyFollowingDatabase"/> instance for mocking. </returns>
        public static KustoReadOnlyFollowingDatabase KustoReadOnlyFollowingDatabase(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, KustoProvisioningState? provisioningState = null, TimeSpan? softDeletePeriod = null, TimeSpan? hotCachePeriod = null, float? statisticsSize = null, string leaderClusterResourceId = null, string attachedDatabaseConfigurationName = null, KustoDatabasePrincipalsModificationKind? principalsModificationKind = null, KustoDatabaseTableLevelSharingProperties tableLevelSharingProperties = null, string originalDatabaseName = null, KustoDatabaseShareOrigin? databaseShareOrigin = null, DateTimeOffset? suspensionStartOn = null)
        {
            return new KustoReadOnlyFollowingDatabase(
                id,
                name,
                resourceType,
                systemData,
                location,
                KustoKind.ReadOnlyFollowing,
                serializedAdditionalRawData: null,
                provisioningState,
                softDeletePeriod,
                hotCachePeriod,
                statisticsSize != null ? new DatabaseStatistics(statisticsSize, serializedAdditionalRawData: null) : null,
                leaderClusterResourceId,
                attachedDatabaseConfigurationName,
                principalsModificationKind,
                tableLevelSharingProperties,
                originalDatabaseName,
                databaseShareOrigin,
                suspensionStartOn != null ? new SuspensionDetails(suspensionStartOn, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoEventHubDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="eventHubResourceId"> The resource ID of the event hub to be used to create a data connection. </param>
        /// <param name="consumerGroup"> The event hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="eventSystemProperties"> System properties of the event hub. </param>
        /// <param name="compression"> The event hub messages compression type. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <param name="managedIdentityResourceId"> The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub. </param>
        /// <param name="managedIdentityObjectId"> The object ID of the managedIdentityResourceId. </param>
        /// <param name="databaseRouting"> Indication for database routing information from the data connection, by default only database routing information is allowed. </param>
        /// <param name="retrievalStartOn"> When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period. </param>
        /// <returns> A new <see cref="Models.KustoEventHubDataConnection"/> instance for mocking. </returns>
        public static KustoEventHubDataConnection KustoEventHubDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier eventHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, KustoEventHubDataFormat? dataFormat = null, IEnumerable<string> eventSystemProperties = null, EventHubMessagesCompressionType? compression = null, KustoProvisioningState? provisioningState = null, ResourceIdentifier managedIdentityResourceId = null, Guid? managedIdentityObjectId = null, KustoDatabaseRouting? databaseRouting = null, DateTimeOffset? retrievalStartOn = null)
        {
            eventSystemProperties ??= new List<string>();

            return new KustoEventHubDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                DataConnectionKind.EventHub,
                serializedAdditionalRawData: null,
                eventHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                eventSystemProperties?.ToList(),
                compression,
                provisioningState,
                managedIdentityResourceId,
                managedIdentityObjectId,
                databaseRouting,
                retrievalStartOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoIotHubDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="iotHubResourceId"> The resource ID of the Iot hub to be used to create a data connection. </param>
        /// <param name="consumerGroup"> The iot hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="eventSystemProperties"> System properties of the iot hub. </param>
        /// <param name="sharedAccessPolicyName"> The name of the share access policy. </param>
        /// <param name="databaseRouting"> Indication for database routing information from the data connection, by default only database routing information is allowed. </param>
        /// <param name="retrievalStartOn"> When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.KustoIotHubDataConnection"/> instance for mocking. </returns>
        public static KustoIotHubDataConnection KustoIotHubDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier iotHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, KustoIotHubDataFormat? dataFormat = null, IEnumerable<string> eventSystemProperties = null, string sharedAccessPolicyName = null, KustoDatabaseRouting? databaseRouting = null, DateTimeOffset? retrievalStartOn = null, KustoProvisioningState? provisioningState = null)
        {
            eventSystemProperties ??= new List<string>();

            return new KustoIotHubDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                DataConnectionKind.IotHub,
                serializedAdditionalRawData: null,
                iotHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                eventSystemProperties?.ToList(),
                sharedAccessPolicyName,
                databaseRouting,
                retrievalStartOn,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoEventGridDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="storageAccountResourceId"> The resource ID of the storage account where the data resides. </param>
        /// <param name="eventGridResourceId"> The resource ID of the event grid that is subscribed to the storage account events. </param>
        /// <param name="eventHubResourceId"> The resource ID where the event grid is configured to send events. </param>
        /// <param name="consumerGroup"> The event hub consumer group. </param>
        /// <param name="tableName"> The table where the data should be ingested. Optionally the table information can be added to each message. </param>
        /// <param name="mappingRuleName"> The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message. </param>
        /// <param name="dataFormat"> The data format of the message. Optionally the data format can be added to each message. </param>
        /// <param name="isFirstRecordIgnored"> A Boolean value that, if set to true, indicates that ingestion should ignore the first record of every file. </param>
        /// <param name="blobStorageEventType"> The name of blob storage event type to process. </param>
        /// <param name="managedIdentityResourceId"> The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub and storage account. </param>
        /// <param name="managedIdentityObjectId"> The object ID of managedIdentityResourceId. </param>
        /// <param name="databaseRouting"> Indication for database routing information from the data connection, by default only database routing information is allowed. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.KustoEventGridDataConnection"/> instance for mocking. </returns>
        public static KustoEventGridDataConnection KustoEventGridDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier storageAccountResourceId = null, ResourceIdentifier eventGridResourceId = null, ResourceIdentifier eventHubResourceId = null, string consumerGroup = null, string tableName = null, string mappingRuleName = null, KustoEventGridDataFormat? dataFormat = null, bool? isFirstRecordIgnored = null, BlobStorageEventType? blobStorageEventType = null, ResourceIdentifier managedIdentityResourceId = null, Guid? managedIdentityObjectId = null, KustoDatabaseRouting? databaseRouting = null, KustoProvisioningState? provisioningState = null)
        {
            return new KustoEventGridDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                DataConnectionKind.EventGrid,
                serializedAdditionalRawData: null,
                storageAccountResourceId,
                eventGridResourceId,
                eventHubResourceId,
                consumerGroup,
                tableName,
                mappingRuleName,
                dataFormat,
                isFirstRecordIgnored,
                blobStorageEventType,
                managedIdentityResourceId,
                managedIdentityObjectId,
                databaseRouting,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoCosmosDBDataConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="tableName"> The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table. </param>
        /// <param name="mappingRuleName"> The name of an existing mapping rule to use when ingesting the retrieved data. </param>
        /// <param name="managedIdentityResourceId"> The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB. </param>
        /// <param name="managedIdentityObjectId"> The object ID of the managed identity resource. </param>
        /// <param name="cosmosDBAccountResourceId"> The resource ID of the Cosmos DB account used to create the data connection. </param>
        /// <param name="cosmosDBDatabase"> The name of an existing database in the Cosmos DB account. </param>
        /// <param name="cosmosDBContainer"> The name of an existing container in the Cosmos DB database. </param>
        /// <param name="retrievalStartOn"> Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date. </param>
        /// <param name="provisioningState"> The provisioned state of the resource. </param>
        /// <returns> A new <see cref="Models.KustoCosmosDBDataConnection"/> instance for mocking. </returns>
        public static KustoCosmosDBDataConnection KustoCosmosDBDataConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string tableName = null, string mappingRuleName = null, ResourceIdentifier managedIdentityResourceId = null, Guid? managedIdentityObjectId = null, ResourceIdentifier cosmosDBAccountResourceId = null, string cosmosDBDatabase = null, string cosmosDBContainer = null, DateTimeOffset? retrievalStartOn = null, KustoProvisioningState? provisioningState = null)
        {
            return new KustoCosmosDBDataConnection(
                id,
                name,
                resourceType,
                systemData,
                location,
                DataConnectionKind.CosmosDB,
                serializedAdditionalRawData: null,
                tableName,
                mappingRuleName,
                managedIdentityResourceId,
                managedIdentityObjectId,
                cosmosDBAccountResourceId,
                cosmosDBDatabase,
                cosmosDBContainer,
                retrievalStartOn,
                provisioningState);
        }
    }
}
