// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Kusto.Samples
{
    public partial class Sample_KustoManagedPrivateEndpointResource
    {
        // KustoManagedPrivateEndpointsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_KustoManagedPrivateEndpointsGet()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoManagedPrivateEndpointsGet.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoManagedPrivateEndpointResource created on azure
            // for more information of creating KustoManagedPrivateEndpointResource, please refer to the document of KustoManagedPrivateEndpointResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster";
            string managedPrivateEndpointName = "managedPrivateEndpointTest";
            ResourceIdentifier kustoManagedPrivateEndpointResourceId = KustoManagedPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, managedPrivateEndpointName);
            KustoManagedPrivateEndpointResource kustoManagedPrivateEndpoint = client.GetKustoManagedPrivateEndpointResource(kustoManagedPrivateEndpointResourceId);

            // invoke the operation
            KustoManagedPrivateEndpointResource result = await kustoManagedPrivateEndpoint.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KustoManagedPrivateEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // KustoManagedPrivateEndpointsUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_KustoManagedPrivateEndpointsUpdate()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoManagedPrivateEndpointsUpdate.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoManagedPrivateEndpointResource created on azure
            // for more information of creating KustoManagedPrivateEndpointResource, please refer to the document of KustoManagedPrivateEndpointResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster";
            string managedPrivateEndpointName = "managedPrivateEndpointTest";
            ResourceIdentifier kustoManagedPrivateEndpointResourceId = KustoManagedPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, managedPrivateEndpointName);
            KustoManagedPrivateEndpointResource kustoManagedPrivateEndpoint = client.GetKustoManagedPrivateEndpointResource(kustoManagedPrivateEndpointResourceId);

            // invoke the operation
            KustoManagedPrivateEndpointData data = new KustoManagedPrivateEndpointData()
            {
                PrivateLinkResourceId = new ResourceIdentifier("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest"),
                GroupId = "blob",
                RequestMessage = "Please Approve Managed Private Endpoint Request.",
            };
            ArmOperation<KustoManagedPrivateEndpointResource> lro = await kustoManagedPrivateEndpoint.UpdateAsync(WaitUntil.Completed, data);
            KustoManagedPrivateEndpointResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KustoManagedPrivateEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ManagedPrivateEndpointsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ManagedPrivateEndpointsDelete()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoManagedPrivateEndpointsDelete.json
            // this example is just showing the usage of "ManagedPrivateEndpoints_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoManagedPrivateEndpointResource created on azure
            // for more information of creating KustoManagedPrivateEndpointResource, please refer to the document of KustoManagedPrivateEndpointResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster";
            string managedPrivateEndpointName = "managedPrivateEndpointTest";
            ResourceIdentifier kustoManagedPrivateEndpointResourceId = KustoManagedPrivateEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, managedPrivateEndpointName);
            KustoManagedPrivateEndpointResource kustoManagedPrivateEndpoint = client.GetKustoManagedPrivateEndpointResource(kustoManagedPrivateEndpointResourceId);

            // invoke the operation
            await kustoManagedPrivateEndpoint.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
