// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Kusto.Models;

namespace Azure.ResourceManager.Kusto.Samples
{
    public partial class Sample_KustoAttachedDatabaseConfigurationResource
    {
        // AttachedDatabaseConfigurationsGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AttachedDatabaseConfigurationsGet()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoAttachedDatabaseConfigurationsGet.json
            // this example is just showing the usage of "AttachedDatabaseConfigurations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoAttachedDatabaseConfigurationResource created on azure
            // for more information of creating KustoAttachedDatabaseConfigurationResource, please refer to the document of KustoAttachedDatabaseConfigurationResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster2";
            string attachedDatabaseConfigurationName = "attachedDatabaseConfigurationsTest";
            ResourceIdentifier kustoAttachedDatabaseConfigurationResourceId = KustoAttachedDatabaseConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, attachedDatabaseConfigurationName);
            KustoAttachedDatabaseConfigurationResource kustoAttachedDatabaseConfiguration = client.GetKustoAttachedDatabaseConfigurationResource(kustoAttachedDatabaseConfigurationResourceId);

            // invoke the operation
            KustoAttachedDatabaseConfigurationResource result = await kustoAttachedDatabaseConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KustoAttachedDatabaseConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AttachedDatabaseConfigurationsCreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AttachedDatabaseConfigurationsCreateOrUpdate()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoAttachedDatabaseConfigurationsCreateOrUpdate.json
            // this example is just showing the usage of "AttachedDatabaseConfigurations_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoAttachedDatabaseConfigurationResource created on azure
            // for more information of creating KustoAttachedDatabaseConfigurationResource, please refer to the document of KustoAttachedDatabaseConfigurationResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster2";
            string attachedDatabaseConfigurationName = "attachedDatabaseConfigurationsTest";
            ResourceIdentifier kustoAttachedDatabaseConfigurationResourceId = KustoAttachedDatabaseConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, attachedDatabaseConfigurationName);
            KustoAttachedDatabaseConfigurationResource kustoAttachedDatabaseConfiguration = client.GetKustoAttachedDatabaseConfigurationResource(kustoAttachedDatabaseConfigurationResourceId);

            // invoke the operation
            KustoAttachedDatabaseConfigurationData data = new KustoAttachedDatabaseConfigurationData()
            {
                Location = new AzureLocation("westus"),
                DatabaseName = "kustodatabase",
                ClusterResourceId = new ResourceIdentifier("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Kusto/Clusters/kustoCluster2"),
                DefaultPrincipalsModificationKind = KustoDatabaseDefaultPrincipalsModificationKind.Union,
                TableLevelSharingProperties = new KustoDatabaseTableLevelSharingProperties()
                {
                    TablesToInclude =
{
"Table1"
},
                    TablesToExclude =
{
"Table2"
},
                    ExternalTablesToInclude =
{
"ExternalTable1"
},
                    ExternalTablesToExclude =
{
"ExternalTable2"
},
                    MaterializedViewsToInclude =
{
"MaterializedViewTable1"
},
                    MaterializedViewsToExclude =
{
"MaterializedViewTable2"
},
                },
                DatabaseNameOverride = "overridekustodatabase",
            };
            ArmOperation<KustoAttachedDatabaseConfigurationResource> lro = await kustoAttachedDatabaseConfiguration.UpdateAsync(WaitUntil.Completed, data);
            KustoAttachedDatabaseConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            KustoAttachedDatabaseConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AttachedDatabaseConfigurationsDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_AttachedDatabaseConfigurationsDelete()
        {
            // Generated from example definition: specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoAttachedDatabaseConfigurationsDelete.json
            // this example is just showing the usage of "AttachedDatabaseConfigurations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this KustoAttachedDatabaseConfigurationResource created on azure
            // for more information of creating KustoAttachedDatabaseConfigurationResource, please refer to the document of KustoAttachedDatabaseConfigurationResource
            string subscriptionId = "12345678-1234-1234-1234-123456789098";
            string resourceGroupName = "kustorptest";
            string clusterName = "kustoCluster";
            string attachedDatabaseConfigurationName = "attachedDatabaseConfigurationsTest";
            ResourceIdentifier kustoAttachedDatabaseConfigurationResourceId = KustoAttachedDatabaseConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, clusterName, attachedDatabaseConfigurationName);
            KustoAttachedDatabaseConfigurationResource kustoAttachedDatabaseConfiguration = client.GetKustoAttachedDatabaseConfigurationResource(kustoAttachedDatabaseConfigurationResourceId);

            // invoke the operation
            await kustoAttachedDatabaseConfiguration.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
