// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Parameters to authenticate using Service Principal. </summary>
    public partial class KubernetesServicePrincipalUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesServicePrincipalUpdateContent"/>. </summary>
        public KubernetesServicePrincipalUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesServicePrincipalUpdateContent"/>. </summary>
        /// <param name="clientId"> The client Id for authenticating a Service Principal. </param>
        /// <param name="tenantId"> The tenant Id for authenticating a Service Principal. </param>
        /// <param name="clientSecret"> The client secret for authenticating a Service Principal. </param>
        /// <param name="clientCertificate"> Base64-encoded certificate used to authenticate a Service Principal. </param>
        /// <param name="clientCertificatePassword"> The password for the certificate used to authenticate a Service Principal. </param>
        /// <param name="clientCertificateSendChain"> Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesServicePrincipalUpdateContent(Guid? clientId, Guid? tenantId, string clientSecret, string clientCertificate, string clientCertificatePassword, bool? clientCertificateSendChain, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClientId = clientId;
            TenantId = tenantId;
            ClientSecret = clientSecret;
            ClientCertificate = clientCertificate;
            ClientCertificatePassword = clientCertificatePassword;
            ClientCertificateSendChain = clientCertificateSendChain;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The client Id for authenticating a Service Principal. </summary>
        [WirePath("clientId")]
        public Guid? ClientId { get; set; }
        /// <summary> The tenant Id for authenticating a Service Principal. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> The client secret for authenticating a Service Principal. </summary>
        [WirePath("clientSecret")]
        public string ClientSecret { get; set; }
        /// <summary> Base64-encoded certificate used to authenticate a Service Principal. </summary>
        [WirePath("clientCertificate")]
        public string ClientCertificate { get; set; }
        /// <summary> The password for the certificate used to authenticate a Service Principal. </summary>
        [WirePath("clientCertificatePassword")]
        public string ClientCertificatePassword { get; set; }
        /// <summary> Specifies whether to include x5c header in client claims when acquiring a token to enable subject name / issuer based authentication for the Client Certificate. </summary>
        [WirePath("clientCertificateSendChain")]
        public bool? ClientCertificateSendChain { get; set; }
    }
}
