// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Scope at which the operator will be installed. </summary>
    public readonly partial struct KubernetesOperatorScope : IEquatable<KubernetesOperatorScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesOperatorScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesOperatorScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterValue = "cluster";
        private const string NamespaceValue = "namespace";

        /// <summary> cluster. </summary>
        public static KubernetesOperatorScope Cluster { get; } = new KubernetesOperatorScope(ClusterValue);
        /// <summary> namespace. </summary>
        public static KubernetesOperatorScope Namespace { get; } = new KubernetesOperatorScope(NamespaceValue);
        /// <summary> Determines if two <see cref="KubernetesOperatorScope"/> values are the same. </summary>
        public static bool operator ==(KubernetesOperatorScope left, KubernetesOperatorScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesOperatorScope"/> values are not the same. </summary>
        public static bool operator !=(KubernetesOperatorScope left, KubernetesOperatorScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesOperatorScope"/>. </summary>
        public static implicit operator KubernetesOperatorScope(string value) => new KubernetesOperatorScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesOperatorScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesOperatorScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
