// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Type of the operator. </summary>
    public readonly partial struct KubernetesOperator : IEquatable<KubernetesOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FluxValue = "Flux";

        /// <summary> Flux. </summary>
        public static KubernetesOperator Flux { get; } = new KubernetesOperator(FluxValue);
        /// <summary> Determines if two <see cref="KubernetesOperator"/> values are the same. </summary>
        public static bool operator ==(KubernetesOperator left, KubernetesOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesOperator"/> values are not the same. </summary>
        public static bool operator !=(KubernetesOperator left, KubernetesOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesOperator"/>. </summary>
        public static implicit operator KubernetesOperator(string value) => new KubernetesOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
