// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Parameters to reconcile to the GitRepository source kind type. </summary>
    public partial class KubernetesGitRepositoryUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesGitRepositoryUpdateContent"/>. </summary>
        public KubernetesGitRepositoryUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesGitRepositoryUpdateContent"/>. </summary>
        /// <param name="uri"> The URL to sync for the flux configuration git repository. </param>
        /// <param name="timeoutInSeconds"> The maximum time to attempt to reconcile the cluster git repository source with the remote. </param>
        /// <param name="syncIntervalInSeconds"> The interval at which to re-reconcile the cluster git repository source with the remote. </param>
        /// <param name="repositoryRef"> The source reference for the GitRepository object. </param>
        /// <param name="sshKnownHosts"> Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH. </param>
        /// <param name="httpsUser"> Plaintext HTTPS username used to access private git repositories over HTTPS. </param>
        /// <param name="httpsCACert"> Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS. </param>
        /// <param name="localAuthRef"> Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesGitRepositoryUpdateContent(Uri uri, long? timeoutInSeconds, long? syncIntervalInSeconds, KubernetesGitRepositoryRef repositoryRef, string sshKnownHosts, string httpsUser, string httpsCACert, string localAuthRef, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Uri = uri;
            TimeoutInSeconds = timeoutInSeconds;
            SyncIntervalInSeconds = syncIntervalInSeconds;
            RepositoryRef = repositoryRef;
            SshKnownHosts = sshKnownHosts;
            HttpsUser = httpsUser;
            HttpsCACert = httpsCACert;
            LocalAuthRef = localAuthRef;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The URL to sync for the flux configuration git repository. </summary>
        [WirePath("url")]
        public Uri Uri { get; set; }
        /// <summary> The maximum time to attempt to reconcile the cluster git repository source with the remote. </summary>
        [WirePath("timeoutInSeconds")]
        public long? TimeoutInSeconds { get; set; }
        /// <summary> The interval at which to re-reconcile the cluster git repository source with the remote. </summary>
        [WirePath("syncIntervalInSeconds")]
        public long? SyncIntervalInSeconds { get; set; }
        /// <summary> The source reference for the GitRepository object. </summary>
        [WirePath("repositoryRef")]
        public KubernetesGitRepositoryRef RepositoryRef { get; set; }
        /// <summary> Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH. </summary>
        [WirePath("sshKnownHosts")]
        public string SshKnownHosts { get; set; }
        /// <summary> Plaintext HTTPS username used to access private git repositories over HTTPS. </summary>
        [WirePath("httpsUser")]
        public string HttpsUser { get; set; }
        /// <summary> Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS. </summary>
        [WirePath("httpsCACert")]
        public string HttpsCACert { get; set; }
        /// <summary> Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets. </summary>
        [WirePath("localAuthRef")]
        public string LocalAuthRef { get; set; }
    }
}
