// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> The source reference for the GitRepository object. </summary>
    public partial class KubernetesGitRepositoryRef
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesGitRepositoryRef"/>. </summary>
        public KubernetesGitRepositoryRef()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesGitRepositoryRef"/>. </summary>
        /// <param name="branch"> The git repository branch name to checkout. </param>
        /// <param name="tag"> The git repository tag name to checkout. This takes precedence over branch. </param>
        /// <param name="semver"> The semver range used to match against git repository tags. This takes precedence over tag. </param>
        /// <param name="commit"> The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesGitRepositoryRef(string branch, string tag, string semver, string commit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Branch = branch;
            Tag = tag;
            Semver = semver;
            Commit = commit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The git repository branch name to checkout. </summary>
        [WirePath("branch")]
        public string Branch { get; set; }
        /// <summary> The git repository tag name to checkout. This takes precedence over branch. </summary>
        [WirePath("tag")]
        public string Tag { get; set; }
        /// <summary> The semver range used to match against git repository tags. This takes precedence over tag. </summary>
        [WirePath("semver")]
        public string Semver { get; set; }
        /// <summary> The commit SHA to checkout. This value must be combined with the branch name to be valid. This takes precedence over semver. </summary>
        [WirePath("commit")]
        public string Commit { get; set; }
    }
}
