// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    public partial class KubernetesGitRepositoryRef : IUtf8JsonSerializable, IJsonModel<KubernetesGitRepositoryRef>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KubernetesGitRepositoryRef>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KubernetesGitRepositoryRef>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesGitRepositoryRef>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesGitRepositoryRef)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Branch))
            {
                if (Branch != null)
                {
                    writer.WritePropertyName("branch"u8);
                    writer.WriteStringValue(Branch);
                }
                else
                {
                    writer.WriteNull("branch");
                }
            }
            if (Optional.IsDefined(Tag))
            {
                if (Tag != null)
                {
                    writer.WritePropertyName("tag"u8);
                    writer.WriteStringValue(Tag);
                }
                else
                {
                    writer.WriteNull("tag");
                }
            }
            if (Optional.IsDefined(Semver))
            {
                if (Semver != null)
                {
                    writer.WritePropertyName("semver"u8);
                    writer.WriteStringValue(Semver);
                }
                else
                {
                    writer.WriteNull("semver");
                }
            }
            if (Optional.IsDefined(Commit))
            {
                if (Commit != null)
                {
                    writer.WritePropertyName("commit"u8);
                    writer.WriteStringValue(Commit);
                }
                else
                {
                    writer.WriteNull("commit");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        KubernetesGitRepositoryRef IJsonModel<KubernetesGitRepositoryRef>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesGitRepositoryRef>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesGitRepositoryRef)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKubernetesGitRepositoryRef(document.RootElement, options);
        }

        internal static KubernetesGitRepositoryRef DeserializeKubernetesGitRepositoryRef(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string branch = default;
            string tag = default;
            string semver = default;
            string commit = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("branch"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        branch = null;
                        continue;
                    }
                    branch = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        tag = null;
                        continue;
                    }
                    tag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("semver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        semver = null;
                        continue;
                    }
                    semver = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("commit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        commit = null;
                        continue;
                    }
                    commit = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KubernetesGitRepositoryRef(branch, tag, semver, commit, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Branch), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  branch: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Branch))
                {
                    builder.Append("  branch: ");
                    if (Branch.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Branch}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Branch}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tag), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tag: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Tag))
                {
                    builder.Append("  tag: ");
                    if (Tag.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Tag}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Tag}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Semver), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  semver: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Semver))
                {
                    builder.Append("  semver: ");
                    if (Semver.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Semver}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Semver}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Commit), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  commit: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Commit))
                {
                    builder.Append("  commit: ");
                    if (Commit.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Commit}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Commit}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<KubernetesGitRepositoryRef>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesGitRepositoryRef>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(KubernetesGitRepositoryRef)} does not support writing '{options.Format}' format.");
            }
        }

        KubernetesGitRepositoryRef IPersistableModel<KubernetesGitRepositoryRef>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesGitRepositoryRef>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKubernetesGitRepositoryRef(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KubernetesGitRepositoryRef)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KubernetesGitRepositoryRef>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
