// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Scope at which the configuration will be installed. </summary>
    public readonly partial struct KubernetesConfigurationScope : IEquatable<KubernetesConfigurationScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesConfigurationScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesConfigurationScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterValue = "cluster";
        private const string NamespaceValue = "namespace";

        /// <summary> cluster. </summary>
        public static KubernetesConfigurationScope Cluster { get; } = new KubernetesConfigurationScope(ClusterValue);
        /// <summary> namespace. </summary>
        public static KubernetesConfigurationScope Namespace { get; } = new KubernetesConfigurationScope(NamespaceValue);
        /// <summary> Determines if two <see cref="KubernetesConfigurationScope"/> values are the same. </summary>
        public static bool operator ==(KubernetesConfigurationScope left, KubernetesConfigurationScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesConfigurationScope"/> values are not the same. </summary>
        public static bool operator !=(KubernetesConfigurationScope left, KubernetesConfigurationScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesConfigurationScope"/>. </summary>
        public static implicit operator KubernetesConfigurationScope(string value) => new KubernetesConfigurationScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesConfigurationScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesConfigurationScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
