// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> The provisioning state of the resource. </summary>
    public readonly partial struct KubernetesConfigurationProvisioningState : IEquatable<KubernetesConfigurationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesConfigurationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesConfigurationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Succeeded. </summary>
        public static KubernetesConfigurationProvisioningState Succeeded { get; } = new KubernetesConfigurationProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static KubernetesConfigurationProvisioningState Failed { get; } = new KubernetesConfigurationProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static KubernetesConfigurationProvisioningState Canceled { get; } = new KubernetesConfigurationProvisioningState(CanceledValue);
        /// <summary> Creating. </summary>
        public static KubernetesConfigurationProvisioningState Creating { get; } = new KubernetesConfigurationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static KubernetesConfigurationProvisioningState Updating { get; } = new KubernetesConfigurationProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static KubernetesConfigurationProvisioningState Deleting { get; } = new KubernetesConfigurationProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="KubernetesConfigurationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(KubernetesConfigurationProvisioningState left, KubernetesConfigurationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesConfigurationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(KubernetesConfigurationProvisioningState left, KubernetesConfigurationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesConfigurationProvisioningState"/>. </summary>
        public static implicit operator KubernetesConfigurationProvisioningState(string value) => new KubernetesConfigurationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesConfigurationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesConfigurationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
