// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> Level of the message. </summary>
    public readonly partial struct KubernetesConfigurationMesageLevel : IEquatable<KubernetesConfigurationMesageLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesConfigurationMesageLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesConfigurationMesageLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ErrorValue = "Error";
        private const string WarningValue = "Warning";
        private const string InformationValue = "Information";

        /// <summary> Error. </summary>
        public static KubernetesConfigurationMesageLevel Error { get; } = new KubernetesConfigurationMesageLevel(ErrorValue);
        /// <summary> Warning. </summary>
        public static KubernetesConfigurationMesageLevel Warning { get; } = new KubernetesConfigurationMesageLevel(WarningValue);
        /// <summary> Information. </summary>
        public static KubernetesConfigurationMesageLevel Information { get; } = new KubernetesConfigurationMesageLevel(InformationValue);
        /// <summary> Determines if two <see cref="KubernetesConfigurationMesageLevel"/> values are the same. </summary>
        public static bool operator ==(KubernetesConfigurationMesageLevel left, KubernetesConfigurationMesageLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesConfigurationMesageLevel"/> values are not the same. </summary>
        public static bool operator !=(KubernetesConfigurationMesageLevel left, KubernetesConfigurationMesageLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesConfigurationMesageLevel"/>. </summary>
        public static implicit operator KubernetesConfigurationMesageLevel(string value) => new KubernetesConfigurationMesageLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesConfigurationMesageLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesConfigurationMesageLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
