// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KubernetesConfiguration.Models
{
    /// <summary> The compliance state of the configuration. </summary>
    public readonly partial struct KubernetesConfigurationComplianceStateType : IEquatable<KubernetesConfigurationComplianceStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesConfigurationComplianceStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesConfigurationComplianceStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string CompliantValue = "Compliant";
        private const string NoncompliantValue = "Noncompliant";
        private const string InstalledValue = "Installed";
        private const string FailedValue = "Failed";

        /// <summary> Pending. </summary>
        public static KubernetesConfigurationComplianceStateType Pending { get; } = new KubernetesConfigurationComplianceStateType(PendingValue);
        /// <summary> Compliant. </summary>
        public static KubernetesConfigurationComplianceStateType Compliant { get; } = new KubernetesConfigurationComplianceStateType(CompliantValue);
        /// <summary> Noncompliant. </summary>
        public static KubernetesConfigurationComplianceStateType Noncompliant { get; } = new KubernetesConfigurationComplianceStateType(NoncompliantValue);
        /// <summary> Installed. </summary>
        public static KubernetesConfigurationComplianceStateType Installed { get; } = new KubernetesConfigurationComplianceStateType(InstalledValue);
        /// <summary> Failed. </summary>
        public static KubernetesConfigurationComplianceStateType Failed { get; } = new KubernetesConfigurationComplianceStateType(FailedValue);
        /// <summary> Determines if two <see cref="KubernetesConfigurationComplianceStateType"/> values are the same. </summary>
        public static bool operator ==(KubernetesConfigurationComplianceStateType left, KubernetesConfigurationComplianceStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesConfigurationComplianceStateType"/> values are not the same. </summary>
        public static bool operator !=(KubernetesConfigurationComplianceStateType left, KubernetesConfigurationComplianceStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesConfigurationComplianceStateType"/>. </summary>
        public static implicit operator KubernetesConfigurationComplianceStateType(string value) => new KubernetesConfigurationComplianceStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesConfigurationComplianceStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesConfigurationComplianceStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
