// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.KubernetesConfiguration
{
    internal class KubernetesFluxConfigurationOperationSource : IOperationSource<KubernetesFluxConfigurationResource>
    {
        private readonly ArmClient _client;

        internal KubernetesFluxConfigurationOperationSource(ArmClient client)
        {
            _client = client;
        }

        KubernetesFluxConfigurationResource IOperationSource<KubernetesFluxConfigurationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KubernetesFluxConfigurationData.DeserializeKubernetesFluxConfigurationData(document.RootElement);
            return new KubernetesFluxConfigurationResource(_client, data);
        }

        async ValueTask<KubernetesFluxConfigurationResource> IOperationSource<KubernetesFluxConfigurationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KubernetesFluxConfigurationData.DeserializeKubernetesFluxConfigurationData(document.RootElement);
            return new KubernetesFluxConfigurationResource(_client, data);
        }
    }
}
