// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.KubernetesConfiguration.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.KubernetesConfiguration
{
    public partial class KubernetesSourceControlConfigurationData : IUtf8JsonSerializable, IJsonModel<KubernetesSourceControlConfigurationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KubernetesSourceControlConfigurationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KubernetesSourceControlConfigurationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesSourceControlConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesSourceControlConfigurationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(RepositoryUri))
            {
                writer.WritePropertyName("repositoryUrl"u8);
                writer.WriteStringValue(RepositoryUri.AbsoluteUri);
            }
            if (Optional.IsDefined(OperatorNamespace))
            {
                writer.WritePropertyName("operatorNamespace"u8);
                writer.WriteStringValue(OperatorNamespace);
            }
            if (Optional.IsDefined(OperatorInstanceName))
            {
                writer.WritePropertyName("operatorInstanceName"u8);
                writer.WriteStringValue(OperatorInstanceName);
            }
            if (Optional.IsDefined(OperatorType))
            {
                writer.WritePropertyName("operatorType"u8);
                writer.WriteStringValue(OperatorType.Value.ToString());
            }
            if (Optional.IsDefined(OperatorParams))
            {
                writer.WritePropertyName("operatorParams"u8);
                writer.WriteStringValue(OperatorParams);
            }
            if (Optional.IsCollectionDefined(ConfigurationProtectedSettings))
            {
                writer.WritePropertyName("configurationProtectedSettings"u8);
                writer.WriteStartObject();
                foreach (var item in ConfigurationProtectedSettings)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(OperatorScope))
            {
                writer.WritePropertyName("operatorScope"u8);
                writer.WriteStringValue(OperatorScope.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RepositoryPublicKey))
            {
                writer.WritePropertyName("repositoryPublicKey"u8);
                writer.WriteStringValue(RepositoryPublicKey);
            }
            if (Optional.IsDefined(SshKnownHostsContents))
            {
                writer.WritePropertyName("sshKnownHostsContents"u8);
                writer.WriteStringValue(SshKnownHostsContents);
            }
            if (Optional.IsDefined(IsHelmOperatorEnabled))
            {
                writer.WritePropertyName("enableHelmOperator"u8);
                writer.WriteBooleanValue(IsHelmOperatorEnabled.Value);
            }
            if (Optional.IsDefined(HelmOperatorProperties))
            {
                writer.WritePropertyName("helmOperatorProperties"u8);
                writer.WriteObjectValue(HelmOperatorProperties, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ComplianceStatus))
            {
                writer.WritePropertyName("complianceStatus"u8);
                writer.WriteObjectValue(ComplianceStatus, options);
            }
            writer.WriteEndObject();
        }

        KubernetesSourceControlConfigurationData IJsonModel<KubernetesSourceControlConfigurationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesSourceControlConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesSourceControlConfigurationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKubernetesSourceControlConfigurationData(document.RootElement, options);
        }

        internal static KubernetesSourceControlConfigurationData DeserializeKubernetesSourceControlConfigurationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            Uri repositoryUrl = default;
            string operatorNamespace = default;
            string operatorInstanceName = default;
            KubernetesOperator? operatorType = default;
            string operatorParams = default;
            IDictionary<string, string> configurationProtectedSettings = default;
            KubernetesOperatorScope? operatorScope = default;
            string repositoryPublicKey = default;
            string sshKnownHostsContents = default;
            bool? enableHelmOperator = default;
            HelmOperatorProperties helmOperatorProperties = default;
            KubernetesConfigurationProvisioningStateType? provisioningState = default;
            KubernetesConfigurationComplianceStatus complianceStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("repositoryUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            repositoryUrl = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("operatorNamespace"u8))
                        {
                            operatorNamespace = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("operatorInstanceName"u8))
                        {
                            operatorInstanceName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("operatorType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            operatorType = new KubernetesOperator(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("operatorParams"u8))
                        {
                            operatorParams = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("configurationProtectedSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            configurationProtectedSettings = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("operatorScope"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            operatorScope = new KubernetesOperatorScope(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("repositoryPublicKey"u8))
                        {
                            repositoryPublicKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sshKnownHostsContents"u8))
                        {
                            sshKnownHostsContents = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enableHelmOperator"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableHelmOperator = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("helmOperatorProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            helmOperatorProperties = HelmOperatorProperties.DeserializeHelmOperatorProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new KubernetesConfigurationProvisioningStateType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("complianceStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            complianceStatus = KubernetesConfigurationComplianceStatus.DeserializeKubernetesConfigurationComplianceStatus(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KubernetesSourceControlConfigurationData(
                id,
                name,
                type,
                systemData,
                repositoryUrl,
                operatorNamespace,
                operatorInstanceName,
                operatorType,
                operatorParams,
                configurationProtectedSettings ?? new ChangeTrackingDictionary<string, string>(),
                operatorScope,
                repositoryPublicKey,
                sshKnownHostsContents,
                enableHelmOperator,
                helmOperatorProperties,
                provisioningState,
                complianceStatus,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RepositoryUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    repositoryUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RepositoryUri))
                {
                    builder.Append("    repositoryUrl: ");
                    builder.AppendLine($"'{RepositoryUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorNamespace), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operatorNamespace: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperatorNamespace))
                {
                    builder.Append("    operatorNamespace: ");
                    if (OperatorNamespace.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OperatorNamespace}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OperatorNamespace}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorInstanceName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operatorInstanceName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperatorInstanceName))
                {
                    builder.Append("    operatorInstanceName: ");
                    if (OperatorInstanceName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OperatorInstanceName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OperatorInstanceName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operatorType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperatorType))
                {
                    builder.Append("    operatorType: ");
                    builder.AppendLine($"'{OperatorType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorParams), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operatorParams: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperatorParams))
                {
                    builder.Append("    operatorParams: ");
                    if (OperatorParams.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OperatorParams}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OperatorParams}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConfigurationProtectedSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    configurationProtectedSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ConfigurationProtectedSettings))
                {
                    if (ConfigurationProtectedSettings.Any())
                    {
                        builder.Append("    configurationProtectedSettings: ");
                        builder.AppendLine("{");
                        foreach (var item in ConfigurationProtectedSettings)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperatorScope), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operatorScope: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperatorScope))
                {
                    builder.Append("    operatorScope: ");
                    builder.AppendLine($"'{OperatorScope.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RepositoryPublicKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    repositoryPublicKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RepositoryPublicKey))
                {
                    builder.Append("    repositoryPublicKey: ");
                    if (RepositoryPublicKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RepositoryPublicKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RepositoryPublicKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SshKnownHostsContents), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sshKnownHostsContents: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SshKnownHostsContents))
                {
                    builder.Append("    sshKnownHostsContents: ");
                    if (SshKnownHostsContents.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SshKnownHostsContents}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SshKnownHostsContents}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsHelmOperatorEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableHelmOperator: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsHelmOperatorEnabled))
                {
                    builder.Append("    enableHelmOperator: ");
                    var boolValue = IsHelmOperatorEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HelmOperatorProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    helmOperatorProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HelmOperatorProperties))
                {
                    builder.Append("    helmOperatorProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, HelmOperatorProperties, options, 4, false, "    helmOperatorProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComplianceStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    complianceStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ComplianceStatus))
                {
                    builder.Append("    complianceStatus: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ComplianceStatus, options, 4, false, "    complianceStatus: ");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<KubernetesSourceControlConfigurationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesSourceControlConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(KubernetesSourceControlConfigurationData)} does not support writing '{options.Format}' format.");
            }
        }

        KubernetesSourceControlConfigurationData IPersistableModel<KubernetesSourceControlConfigurationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesSourceControlConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKubernetesSourceControlConfigurationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KubernetesSourceControlConfigurationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KubernetesSourceControlConfigurationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
