// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.KubernetesConfiguration.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.KubernetesConfiguration
{
    public partial class KubernetesFluxConfigurationData : IUtf8JsonSerializable, IJsonModel<KubernetesFluxConfigurationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KubernetesFluxConfigurationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KubernetesFluxConfigurationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesFluxConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesFluxConfigurationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Scope))
            {
                writer.WritePropertyName("scope"u8);
                writer.WriteStringValue(Scope.Value.ToString());
            }
            if (Optional.IsDefined(Namespace))
            {
                writer.WritePropertyName("namespace"u8);
                writer.WriteStringValue(Namespace);
            }
            if (Optional.IsDefined(SourceKind))
            {
                writer.WritePropertyName("sourceKind"u8);
                writer.WriteStringValue(SourceKind.Value.ToString());
            }
            if (Optional.IsDefined(IsReconciliationSuspended))
            {
                writer.WritePropertyName("suspend"u8);
                writer.WriteBooleanValue(IsReconciliationSuspended.Value);
            }
            if (Optional.IsDefined(GitRepository))
            {
                if (GitRepository != null)
                {
                    writer.WritePropertyName("gitRepository"u8);
                    writer.WriteObjectValue(GitRepository, options);
                }
                else
                {
                    writer.WriteNull("gitRepository");
                }
            }
            if (Optional.IsDefined(Bucket))
            {
                if (Bucket != null)
                {
                    writer.WritePropertyName("bucket"u8);
                    writer.WriteObjectValue(Bucket, options);
                }
                else
                {
                    writer.WriteNull("bucket");
                }
            }
            if (Optional.IsDefined(AzureBlob))
            {
                if (AzureBlob != null)
                {
                    writer.WritePropertyName("azureBlob"u8);
                    writer.WriteObjectValue(AzureBlob, options);
                }
                else
                {
                    writer.WriteNull("azureBlob");
                }
            }
            if (Optional.IsCollectionDefined(Kustomizations))
            {
                if (Kustomizations != null)
                {
                    writer.WritePropertyName("kustomizations"u8);
                    writer.WriteStartObject();
                    foreach (var item in Kustomizations)
                    {
                        writer.WritePropertyName(item.Key);
                        writer.WriteObjectValue(item.Value, options);
                    }
                    writer.WriteEndObject();
                }
                else
                {
                    writer.WriteNull("kustomizations");
                }
            }
            if (Optional.IsCollectionDefined(ConfigurationProtectedSettings))
            {
                if (ConfigurationProtectedSettings != null)
                {
                    writer.WritePropertyName("configurationProtectedSettings"u8);
                    writer.WriteStartObject();
                    foreach (var item in ConfigurationProtectedSettings)
                    {
                        writer.WritePropertyName(item.Key);
                        writer.WriteStringValue(item.Value);
                    }
                    writer.WriteEndObject();
                }
                else
                {
                    writer.WriteNull("configurationProtectedSettings");
                }
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Statuses))
            {
                if (Statuses != null)
                {
                    writer.WritePropertyName("statuses"u8);
                    writer.WriteStartArray();
                    foreach (var item in Statuses)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("statuses");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(RepositoryPublicKey))
            {
                if (RepositoryPublicKey != null)
                {
                    writer.WritePropertyName("repositoryPublicKey"u8);
                    writer.WriteStringValue(RepositoryPublicKey);
                }
                else
                {
                    writer.WriteNull("repositoryPublicKey");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(SourceSyncedCommitId))
            {
                if (SourceSyncedCommitId != null)
                {
                    writer.WritePropertyName("sourceSyncedCommitId"u8);
                    writer.WriteStringValue(SourceSyncedCommitId);
                }
                else
                {
                    writer.WriteNull("sourceSyncedCommitId");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(SourceUpdatedOn))
            {
                if (SourceUpdatedOn != null)
                {
                    writer.WritePropertyName("sourceUpdatedAt"u8);
                    writer.WriteStringValue(SourceUpdatedOn.Value, "O");
                }
                else
                {
                    writer.WriteNull("sourceUpdatedAt");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(StatusUpdatedOn))
            {
                if (StatusUpdatedOn != null)
                {
                    writer.WritePropertyName("statusUpdatedAt"u8);
                    writer.WriteStringValue(StatusUpdatedOn.Value, "O");
                }
                else
                {
                    writer.WriteNull("statusUpdatedAt");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(ComplianceState))
            {
                writer.WritePropertyName("complianceState"u8);
                writer.WriteStringValue(ComplianceState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorMessage))
            {
                if (ErrorMessage != null)
                {
                    writer.WritePropertyName("errorMessage"u8);
                    writer.WriteStringValue(ErrorMessage);
                }
                else
                {
                    writer.WriteNull("errorMessage");
                }
            }
            writer.WriteEndObject();
        }

        KubernetesFluxConfigurationData IJsonModel<KubernetesFluxConfigurationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesFluxConfigurationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubernetesFluxConfigurationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKubernetesFluxConfigurationData(document.RootElement, options);
        }

        internal static KubernetesFluxConfigurationData DeserializeKubernetesFluxConfigurationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            KubernetesConfigurationScope? scope = default;
            string @namespace = default;
            KubernetesConfigurationSourceKind? sourceKind = default;
            bool? suspend = default;
            KubernetesGitRepository gitRepository = default;
            KubernetesBucket bucket = default;
            KubernetesAzureBlob azureBlob = default;
            IDictionary<string, Kustomization> kustomizations = default;
            IDictionary<string, string> configurationProtectedSettings = default;
            IReadOnlyList<KubernetesObjectStatus> statuses = default;
            string repositoryPublicKey = default;
            string sourceSyncedCommitId = default;
            DateTimeOffset? sourceUpdatedAt = default;
            DateTimeOffset? statusUpdatedAt = default;
            KubernetesFluxComplianceState? complianceState = default;
            KubernetesConfigurationProvisioningState? provisioningState = default;
            string errorMessage = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("scope"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scope = new KubernetesConfigurationScope(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("namespace"u8))
                        {
                            @namespace = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sourceKind"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sourceKind = new KubernetesConfigurationSourceKind(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("suspend"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            suspend = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("gitRepository"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                gitRepository = null;
                                continue;
                            }
                            gitRepository = KubernetesGitRepository.DeserializeKubernetesGitRepository(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("bucket"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                bucket = null;
                                continue;
                            }
                            bucket = KubernetesBucket.DeserializeKubernetesBucket(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("azureBlob"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                azureBlob = null;
                                continue;
                            }
                            azureBlob = KubernetesAzureBlob.DeserializeKubernetesAzureBlob(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("kustomizations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                kustomizations = null;
                                continue;
                            }
                            Dictionary<string, Kustomization> dictionary = new Dictionary<string, Kustomization>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, Kustomization.DeserializeKustomization(property1.Value, options));
                            }
                            kustomizations = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("configurationProtectedSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                configurationProtectedSettings = null;
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            configurationProtectedSettings = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("statuses"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                statuses = null;
                                continue;
                            }
                            List<KubernetesObjectStatus> array = new List<KubernetesObjectStatus>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KubernetesObjectStatus.DeserializeKubernetesObjectStatus(item, options));
                            }
                            statuses = array;
                            continue;
                        }
                        if (property0.NameEquals("repositoryPublicKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                repositoryPublicKey = null;
                                continue;
                            }
                            repositoryPublicKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sourceSyncedCommitId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                sourceSyncedCommitId = null;
                                continue;
                            }
                            sourceSyncedCommitId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sourceUpdatedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                sourceUpdatedAt = null;
                                continue;
                            }
                            sourceUpdatedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("statusUpdatedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                statusUpdatedAt = null;
                                continue;
                            }
                            statusUpdatedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("complianceState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            complianceState = new KubernetesFluxComplianceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new KubernetesConfigurationProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("errorMessage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                errorMessage = null;
                                continue;
                            }
                            errorMessage = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KubernetesFluxConfigurationData(
                id,
                name,
                type,
                systemData,
                scope,
                @namespace,
                sourceKind,
                suspend,
                gitRepository,
                bucket,
                azureBlob,
                kustomizations ?? new ChangeTrackingDictionary<string, Kustomization>(),
                configurationProtectedSettings ?? new ChangeTrackingDictionary<string, string>(),
                statuses ?? new ChangeTrackingList<KubernetesObjectStatus>(),
                repositoryPublicKey,
                sourceSyncedCommitId,
                sourceUpdatedAt,
                statusUpdatedAt,
                complianceState,
                provisioningState,
                errorMessage,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Scope), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scope: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Scope))
                {
                    builder.Append("    scope: ");
                    builder.AppendLine($"'{Scope.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Namespace), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    namespace: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Namespace))
                {
                    builder.Append("    namespace: ");
                    if (Namespace.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Namespace}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Namespace}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceKind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceKind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceKind))
                {
                    builder.Append("    sourceKind: ");
                    builder.AppendLine($"'{SourceKind.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsReconciliationSuspended), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    suspend: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsReconciliationSuspended))
                {
                    builder.Append("    suspend: ");
                    var boolValue = IsReconciliationSuspended.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GitRepository), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    gitRepository: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GitRepository))
                {
                    builder.Append("    gitRepository: ");
                    BicepSerializationHelpers.AppendChildObject(builder, GitRepository, options, 4, false, "    gitRepository: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Bucket), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    bucket: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Bucket))
                {
                    builder.Append("    bucket: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Bucket, options, 4, false, "    bucket: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AzureBlob), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    azureBlob: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AzureBlob))
                {
                    builder.Append("    azureBlob: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AzureBlob, options, 4, false, "    azureBlob: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kustomizations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    kustomizations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Kustomizations))
                {
                    if (Kustomizations.Any())
                    {
                        builder.Append("    kustomizations: ");
                        builder.AppendLine("{");
                        foreach (var item in Kustomizations)
                        {
                            builder.Append($"        '{item.Key}': ");
                            BicepSerializationHelpers.AppendChildObject(builder, item.Value, options, 6, false, "    kustomizations: ");
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConfigurationProtectedSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    configurationProtectedSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ConfigurationProtectedSettings))
                {
                    if (ConfigurationProtectedSettings.Any())
                    {
                        builder.Append("    configurationProtectedSettings: ");
                        builder.AppendLine("{");
                        foreach (var item in ConfigurationProtectedSettings)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Statuses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    statuses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Statuses))
                {
                    if (Statuses.Any())
                    {
                        builder.Append("    statuses: ");
                        builder.AppendLine("[");
                        foreach (var item in Statuses)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    statuses: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RepositoryPublicKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    repositoryPublicKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RepositoryPublicKey))
                {
                    builder.Append("    repositoryPublicKey: ");
                    if (RepositoryPublicKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RepositoryPublicKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RepositoryPublicKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSyncedCommitId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceSyncedCommitId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceSyncedCommitId))
                {
                    builder.Append("    sourceSyncedCommitId: ");
                    if (SourceSyncedCommitId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceSyncedCommitId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceSyncedCommitId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceUpdatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceUpdatedAt: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceUpdatedOn))
                {
                    builder.Append("    sourceUpdatedAt: ");
                    var formattedDateTimeString = TypeFormatters.ToString(SourceUpdatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StatusUpdatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    statusUpdatedAt: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StatusUpdatedOn))
                {
                    builder.Append("    statusUpdatedAt: ");
                    var formattedDateTimeString = TypeFormatters.ToString(StatusUpdatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComplianceState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    complianceState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ComplianceState))
                {
                    builder.Append("    complianceState: ");
                    builder.AppendLine($"'{ComplianceState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ErrorMessage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    errorMessage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ErrorMessage))
                {
                    builder.Append("    errorMessage: ");
                    if (ErrorMessage.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ErrorMessage}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ErrorMessage}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<KubernetesFluxConfigurationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesFluxConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(KubernetesFluxConfigurationData)} does not support writing '{options.Format}' format.");
            }
        }

        KubernetesFluxConfigurationData IPersistableModel<KubernetesFluxConfigurationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubernetesFluxConfigurationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKubernetesFluxConfigurationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KubernetesFluxConfigurationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KubernetesFluxConfigurationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
