// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.KubernetesConfiguration.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableKubernetesConfigurationArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableKubernetesConfigurationArmClient"/> class for mocking. </summary>
        protected MockableKubernetesConfigurationArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableKubernetesConfigurationArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableKubernetesConfigurationArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableKubernetesConfigurationArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="KubernetesClusterExtensionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="KubernetesClusterExtensionResource.CreateResourceIdentifier" /> to create a <see cref="KubernetesClusterExtensionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="KubernetesClusterExtensionResource"/> object. </returns>
        public virtual KubernetesClusterExtensionResource GetKubernetesClusterExtensionResource(ResourceIdentifier id)
        {
            KubernetesClusterExtensionResource.ValidateResourceId(id);
            return new KubernetesClusterExtensionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="KubernetesFluxConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="KubernetesFluxConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="KubernetesFluxConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="KubernetesFluxConfigurationResource"/> object. </returns>
        public virtual KubernetesFluxConfigurationResource GetKubernetesFluxConfigurationResource(ResourceIdentifier id)
        {
            KubernetesFluxConfigurationResource.ValidateResourceId(id);
            return new KubernetesFluxConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="KubernetesSourceControlConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="KubernetesSourceControlConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="KubernetesSourceControlConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="KubernetesSourceControlConfigurationResource"/> object. </returns>
        public virtual KubernetesSourceControlConfigurationResource GetKubernetesSourceControlConfigurationResource(ResourceIdentifier id)
        {
            KubernetesSourceControlConfigurationResource.ValidateResourceId(id);
            return new KubernetesSourceControlConfigurationResource(Client, id);
        }
    }
}
