// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> The storage account create parameters. </summary>
    internal partial class StorageAccountCreateParameters
    {
        /// <summary> Initializes a new instance of <see cref="StorageAccountCreateParameters"/>. </summary>
        /// <param name="resourceId"> Storage account resource id. </param>
        /// <param name="activeKeyName"> Current active storage account key name. </param>
        /// <param name="autoRegenerateKey"> whether keyvault should manage the storage account for the user. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> or <paramref name="activeKeyName"/> is null. </exception>
        public StorageAccountCreateParameters(string resourceId, string activeKeyName, bool autoRegenerateKey)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNull(activeKeyName, nameof(activeKeyName));

            ResourceId = resourceId;
            ActiveKeyName = activeKeyName;
            AutoRegenerateKey = autoRegenerateKey;
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountCreateParameters"/>. </summary>
        /// <param name="resourceId"> Storage account resource id. </param>
        /// <param name="activeKeyName"> Current active storage account key name. </param>
        /// <param name="autoRegenerateKey"> whether keyvault should manage the storage account for the user. </param>
        /// <param name="regenerationPeriod"> The key regeneration time duration specified in ISO-8601 format. </param>
        /// <param name="storageAccountAttributes"> The attributes of the storage account. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        internal StorageAccountCreateParameters(string resourceId, string activeKeyName, bool autoRegenerateKey, string regenerationPeriod, StorageAccountAttributes storageAccountAttributes, IDictionary<string, string> tags)
        {
            ResourceId = resourceId;
            ActiveKeyName = activeKeyName;
            AutoRegenerateKey = autoRegenerateKey;
            RegenerationPeriod = regenerationPeriod;
            StorageAccountAttributes = storageAccountAttributes;
            Tags = tags;
        }

        /// <summary> Storage account resource id. </summary>
        public string ResourceId { get; }
        /// <summary> Current active storage account key name. </summary>
        public string ActiveKeyName { get; }
        /// <summary> whether keyvault should manage the storage account for the user. </summary>
        public bool AutoRegenerateKey { get; }
        /// <summary> The key regeneration time duration specified in ISO-8601 format. </summary>
        public string RegenerationPeriod { get; set; }
        /// <summary> The attributes of the storage account. </summary>
        public StorageAccountAttributes StorageAccountAttributes { get; set; }
        /// <summary> Application specific metadata in the form of key-value pairs. </summary>
        public IDictionary<string, string> Tags { get; }
    }
}
