// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Security.KeyVault.Storage.Models
{
    internal partial class SasDefinitionUpdateParameters : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(TemplateUri))
            {
                writer.WritePropertyName("templateUri"u8);
                writer.WriteStringValue(TemplateUri);
            }
            if (Optional.IsDefined(SasType))
            {
                writer.WritePropertyName("sasType"u8);
                writer.WriteStringValue(SasType.Value.ToString());
            }
            if (Optional.IsDefined(ValidityPeriod))
            {
                writer.WritePropertyName("validityPeriod"u8);
                writer.WriteStringValue(ValidityPeriod);
            }
            if (Optional.IsDefined(SasDefinitionAttributes))
            {
                writer.WritePropertyName("attributes"u8);
                writer.WriteObjectValue(SasDefinitionAttributes);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
