// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> The storage account SAS definition list result. </summary>
    internal partial class SasDefinitionListResult
    {
        /// <summary> Initializes a new instance of <see cref="SasDefinitionListResult"/>. </summary>
        internal SasDefinitionListResult()
        {
            Value = new ChangeTrackingList<SasDefinitionItem>();
        }

        /// <summary> Initializes a new instance of <see cref="SasDefinitionListResult"/>. </summary>
        /// <param name="value"> A response message containing a list of SAS definitions along with a link to the next page of SAS definitions. </param>
        /// <param name="nextLink"> The URL to get the next set of SAS definitions. </param>
        internal SasDefinitionListResult(IReadOnlyList<SasDefinitionItem> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> A response message containing a list of SAS definitions along with a link to the next page of SAS definitions. </summary>
        public IReadOnlyList<SasDefinitionItem> Value { get; }
        /// <summary> The URL to get the next set of SAS definitions. </summary>
        public string NextLink { get; }
    }
}
