// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> The SAS definition item containing storage SAS definition metadata. </summary>
    public partial class SasDefinitionItem
    {
        /// <summary> Initializes a new instance of <see cref="SasDefinitionItem"/>. </summary>
        internal SasDefinitionItem()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SasDefinitionItem"/>. </summary>
        /// <param name="id"> The storage SAS identifier. </param>
        /// <param name="secretId"> The storage account SAS definition secret id. </param>
        /// <param name="attributes"> The SAS definition management attributes. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        internal SasDefinitionItem(string id, string secretId, SasDefinitionAttributes attributes, IReadOnlyDictionary<string, string> tags)
        {
            Id = id;
            SecretId = secretId;
            Attributes = attributes;
            Tags = tags;
        }

        /// <summary> The storage SAS identifier. </summary>
        public string Id { get; }
        /// <summary> The storage account SAS definition secret id. </summary>
        public string SecretId { get; }
        /// <summary> The SAS definition management attributes. </summary>
        public SasDefinitionAttributes Attributes { get; }
        /// <summary> Application specific metadata in the form of key-value pairs. </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
    }
}
