// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> A SAS definition bundle consists of key vault SAS definition details plus its attributes. </summary>
    public partial class SasDefinitionBundle
    {
        /// <summary> Initializes a new instance of <see cref="SasDefinitionBundle"/>. </summary>
        internal SasDefinitionBundle()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SasDefinitionBundle"/>. </summary>
        /// <param name="id"> The SAS definition id. </param>
        /// <param name="secretId"> Storage account SAS definition secret id. </param>
        /// <param name="templateUri"> The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template. </param>
        /// <param name="sasType"> The type of SAS token the SAS definition will create. </param>
        /// <param name="validityPeriod"> The validity period of SAS tokens created according to the SAS definition. </param>
        /// <param name="attributes"> The SAS definition attributes. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        internal SasDefinitionBundle(string id, string secretId, string templateUri, SasTokenType? sasType, string validityPeriod, SasDefinitionAttributes attributes, IReadOnlyDictionary<string, string> tags)
        {
            Id = id;
            SecretId = secretId;
            TemplateUri = templateUri;
            SasType = sasType;
            ValidityPeriod = validityPeriod;
            Attributes = attributes;
            Tags = tags;
        }

        /// <summary> The SAS definition id. </summary>
        public string Id { get; }
        /// <summary> Storage account SAS definition secret id. </summary>
        public string SecretId { get; }
        /// <summary> The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template. </summary>
        public string TemplateUri { get; }
        /// <summary> The type of SAS token the SAS definition will create. </summary>
        public SasTokenType? SasType { get; }
        /// <summary> The validity period of SAS tokens created according to the SAS definition. </summary>
        public string ValidityPeriod { get; }
        /// <summary> The SAS definition attributes. </summary>
        public SasDefinitionAttributes Attributes { get; }
        /// <summary> Application specific metadata in the form of key-value pairs. </summary>
        public IReadOnlyDictionary<string, string> Tags { get; }
    }
}
