// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> The SAS definition management attributes. </summary>
    public partial class SasDefinitionAttributes
    {
        /// <summary> Initializes a new instance of <see cref="SasDefinitionAttributes"/>. </summary>
        public SasDefinitionAttributes()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SasDefinitionAttributes"/>. </summary>
        /// <param name="enabled"> the enabled state of the object. </param>
        /// <param name="created"> Creation time in UTC. </param>
        /// <param name="updated"> Last updated time in UTC. </param>
        /// <param name="recoverableDays"> softDelete data retention days. Value should be &gt;=7 and &lt;=90 when softDelete enabled, otherwise 0. </param>
        /// <param name="recoveryLevel"> Reflects the deletion recovery level currently in effect for SAS definitions in the current vault. If it contains 'Purgeable' the SAS definition can be permanently deleted by a privileged user; otherwise, only the system can purge the SAS definition, at the end of the retention interval. </param>
        internal SasDefinitionAttributes(bool? enabled, DateTimeOffset? created, DateTimeOffset? updated, int? recoverableDays, DeletionRecoveryLevel? recoveryLevel)
        {
            Enabled = enabled;
            Created = created;
            Updated = updated;
            RecoverableDays = recoverableDays;
            RecoveryLevel = recoveryLevel;
        }

        /// <summary> the enabled state of the object. </summary>
        public bool? Enabled { get; set; }
        /// <summary> Creation time in UTC. </summary>
        public DateTimeOffset? Created { get; }
        /// <summary> Last updated time in UTC. </summary>
        public DateTimeOffset? Updated { get; }
        /// <summary> softDelete data retention days. Value should be &gt;=7 and &lt;=90 when softDelete enabled, otherwise 0. </summary>
        public int? RecoverableDays { get; }
        /// <summary> Reflects the deletion recovery level currently in effect for SAS definitions in the current vault. If it contains 'Purgeable' the SAS definition can be permanently deleted by a privileged user; otherwise, only the system can purge the SAS definition, at the end of the retention interval. </summary>
        public DeletionRecoveryLevel? RecoveryLevel { get; }
    }
}
