// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Security.KeyVault.Storage.Models
{
    internal partial class DeletedStorageListResult
    {
        internal static DeletedStorageListResult DeserializeDeletedStorageListResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<DeletedStorageAccountItem> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DeletedStorageAccountItem> array = new List<DeletedStorageAccountItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeletedStorageAccountItem.DeserializeDeletedStorageAccountItem(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new DeletedStorageListResult(value ?? new ChangeTrackingList<DeletedStorageAccountItem>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DeletedStorageListResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDeletedStorageListResult(document.RootElement);
        }
    }
}
