// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> The deleted SAS definition item containing metadata about the deleted SAS definition. </summary>
    public partial class DeletedSasDefinitionItem : SasDefinitionItem
    {
        /// <summary> Initializes a new instance of <see cref="DeletedSasDefinitionItem"/>. </summary>
        internal DeletedSasDefinitionItem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeletedSasDefinitionItem"/>. </summary>
        /// <param name="id"> The storage SAS identifier. </param>
        /// <param name="secretId"> The storage account SAS definition secret id. </param>
        /// <param name="attributes"> The SAS definition management attributes. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        /// <param name="recoveryId"> The url of the recovery object, used to identify and recover the deleted SAS definition. </param>
        /// <param name="scheduledPurgeDate"> The time when the SAS definition is scheduled to be purged, in UTC. </param>
        /// <param name="deletedDate"> The time when the SAS definition was deleted, in UTC. </param>
        internal DeletedSasDefinitionItem(string id, string secretId, SasDefinitionAttributes attributes, IReadOnlyDictionary<string, string> tags, string recoveryId, DateTimeOffset? scheduledPurgeDate, DateTimeOffset? deletedDate) : base(id, secretId, attributes, tags)
        {
            RecoveryId = recoveryId;
            ScheduledPurgeDate = scheduledPurgeDate;
            DeletedDate = deletedDate;
        }

        /// <summary> The url of the recovery object, used to identify and recover the deleted SAS definition. </summary>
        public string RecoveryId { get; }
        /// <summary> The time when the SAS definition is scheduled to be purged, in UTC. </summary>
        public DateTimeOffset? ScheduledPurgeDate { get; }
        /// <summary> The time when the SAS definition was deleted, in UTC. </summary>
        public DateTimeOffset? DeletedDate { get; }
    }
}
