// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Security.KeyVault.Storage.Models
{
    /// <summary> A deleted SAS definition bundle consisting of its previous id, attributes and its tags, as well as information on when it will be purged. </summary>
    public partial class DeletedSasDefinitionBundle : SasDefinitionBundle
    {
        /// <summary> Initializes a new instance of <see cref="DeletedSasDefinitionBundle"/>. </summary>
        internal DeletedSasDefinitionBundle()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeletedSasDefinitionBundle"/>. </summary>
        /// <param name="id"> The SAS definition id. </param>
        /// <param name="secretId"> Storage account SAS definition secret id. </param>
        /// <param name="templateUri"> The SAS definition token template signed with an arbitrary key.  Tokens created according to the SAS definition will have the same properties as the template. </param>
        /// <param name="sasType"> The type of SAS token the SAS definition will create. </param>
        /// <param name="validityPeriod"> The validity period of SAS tokens created according to the SAS definition. </param>
        /// <param name="attributes"> The SAS definition attributes. </param>
        /// <param name="tags"> Application specific metadata in the form of key-value pairs. </param>
        /// <param name="recoveryId"> The url of the recovery object, used to identify and recover the deleted SAS definition. </param>
        /// <param name="scheduledPurgeDate"> The time when the SAS definition is scheduled to be purged, in UTC. </param>
        /// <param name="deletedDate"> The time when the SAS definition was deleted, in UTC. </param>
        internal DeletedSasDefinitionBundle(string id, string secretId, string templateUri, SasTokenType? sasType, string validityPeriod, SasDefinitionAttributes attributes, IReadOnlyDictionary<string, string> tags, string recoveryId, DateTimeOffset? scheduledPurgeDate, DateTimeOffset? deletedDate) : base(id, secretId, templateUri, sasType, validityPeriod, attributes, tags)
        {
            RecoveryId = recoveryId;
            ScheduledPurgeDate = scheduledPurgeDate;
            DeletedDate = deletedDate;
        }

        /// <summary> The url of the recovery object, used to identify and recover the deleted SAS definition. </summary>
        public string RecoveryId { get; }
        /// <summary> The time when the SAS definition is scheduled to be purged, in UTC. </summary>
        public DateTimeOffset? ScheduledPurgeDate { get; }
        /// <summary> The time when the SAS definition was deleted, in UTC. </summary>
        public DateTimeOffset? DeletedDate { get; }
    }
}
