﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

namespace Azure.Security.KeyVault.Certificates.Tests
{
    public partial class CertificateClientLiveTests
    {
        /* pwsh
           Import-Module -Name ./eng/common/scripts/X509Certificate2 # assumes $PWD is repo root
           $cert1 = New-X509Certificate2 -SubjectName 'E=opensource@microsoft.com, CN=Azure SDK, OU=Azure SDK, O=Microsoft, L=Redmond, S=WA, C=US' -ValidDays 3652

           $CaPublicKeyBase64 = $cert1 | Format-X509Certificate2 -Type CertificateBase64
           $CaPrivateKeyPem = $cert1 | Format-X509Certificate2 -Type Pkcs1
           $CaKeyPairPkcs12Base64 = $cert1 | Format-X509Certificate2 -Type Pkcs12Base64
         */

        // Expires: 2031-11-01T14:04:31.0000000-07:00
        private const string CaPublicKeyBase64 =
"MIIDtjCCAp6gAwIBAgIIQtpdjWxHT7EwDQYJKoZIhvcNAQELBQAwgZExCzAJBgNVBAYTAlVTMQsw" +
"CQYDVQQIEwJXQTEQMA4GA1UEBxMHUmVkbW9uZDESMBAGA1UEChMJTWljcm9zb2Z0MRIwEAYDVQQL" +
"EwlBenVyZSBTREsxEjAQBgNVBAMTCUF6dXJlIFNESzEnMCUGCSqGSIb3DQEJARYYb3BlbnNvdXJj" +
"ZUBtaWNyb3NvZnQuY29tMB4XDTIxMTEwMTIxMDQzMVoXDTMxMTEwMTIxMDQzMVowgZExCzAJBgNV" +
"BAYTAlVTMQswCQYDVQQIEwJXQTEQMA4GA1UEBxMHUmVkbW9uZDESMBAGA1UEChMJTWljcm9zb2Z0" +
"MRIwEAYDVQQLEwlBenVyZSBTREsxEjAQBgNVBAMTCUF6dXJlIFNESzEnMCUGCSqGSIb3DQEJARYY" +
"b3BlbnNvdXJjZUBtaWNyb3NvZnQuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA" +
"9AtR7KnWxV2qs5NOGdkPyjbbouTsBwa29dRQDD/9MFu1otRH9X3FCkfFBfoGGd36vwHKvgVL+GOM" +
"vwIw1JzOK5bPxIxpaT7c2Qtx9wYY5w7NA33T95OtGbcuOo2+H9TEQO3Q6zik6ZSCD9CYnBU7Q21k" +
"mq21nOpJUoclqSC5AxYCkA1Jk3t5CLbfCbMca9hy13ztQnflgi97k/xfzOtQDgCmPCYk5stQY/WZ" +
"neB/AcHgdplbGWanFhTMFduySfE7IBTt+UbgjjIDhkrOBPrab9kRIQrSlYaex+MhhUw+iiQVGlw9" +
"cSkICDncGfVUyexJ39JpMRYfyJ7A8pWv8LTx8QIDAQABoxAwDjAMBgNVHRMBAf8EAjAAMA0GCSqG" +
"SIb3DQEBCwUAA4IBAQDTqe8g3abl2/LCfPwu+cgtnFUIdeTGc09SzGqI0QupskbAue92crvo6Uby" +
"1lhhx/17IXyjzs+zmRyPiXFUcWU++HFmVN32mvreyEjPMutHL43ZBEz2kaeUtC81jMiBblFXK142" +
"E9PYaQMLNrpWvz5jg/cei7azUyQ1Wc1FN6Ez/nWMI7wzxvR5TvVchVtJH57F8g9E0eVCxxRxj+zE" +
"SHxoZkZjb0HeMIEiGV4UEHnQsA7FCW3tfA3GYcocW6qwPsFfxRb4fNXnFCB5tp5nszSJLAFT9PuV" +
"nGPWSfyKrCHlyvmpHogt4FL54rbM/3l5TQqfTrn5Pp0TLSxqDsYcPgbI";

        private const string CaPrivateKeyPem =
"-----BEGIN RSA PRIVATE KEY-----\n" +
"MIIEpQIBAAKCAQEA9AtR7KnWxV2qs5NOGdkPyjbbouTsBwa29dRQDD/9MFu1otRH9X3FCkfFBfoG\n" +
"Gd36vwHKvgVL+GOMvwIw1JzOK5bPxIxpaT7c2Qtx9wYY5w7NA33T95OtGbcuOo2+H9TEQO3Q6zik\n" +
"6ZSCD9CYnBU7Q21kmq21nOpJUoclqSC5AxYCkA1Jk3t5CLbfCbMca9hy13ztQnflgi97k/xfzOtQ\n" +
"DgCmPCYk5stQY/WZneB/AcHgdplbGWanFhTMFduySfE7IBTt+UbgjjIDhkrOBPrab9kRIQrSlYae\n" +
"x+MhhUw+iiQVGlw9cSkICDncGfVUyexJ39JpMRYfyJ7A8pWv8LTx8QIDAQABAoIBAQCVBmSctInm\n" +
"M/CNgCJtPlOaFC3DJy/KipsnOuM218xwv1AHgsH+czLjuDfkEm2vVhJMmXeI2gsuPvwvl9Lhwm9T\n" +
"xuBREb08+5o5H/gT9LE4R52ByFCsGo3V6jpcnzm+jlrZm1+8g/aQfJN/vM20YnKyFhcdLX59t8PW\n" +
"lZi10rmn25OZD9PkEsnuOHFuSVkjOj07JY3MAuUGc/O2yLfUC7w8qsV1QvD7I5/bBOuxXRZ521TC\n" +
"u5NkdZ+G7T9+hCkyaeItxd5hB+1wC7VMCxjmXB7GnemAwKFjwH8h6TRuRlYdE/IiNr96REzy5FcD\n" +
"ZQsRr9aT/PXxExfzl4yKexrYoUgRAoGBAP70e+H4ADBftPfHZl2PAEsQAanolWXNSFgkIIAdrXl/\n" +
"2obHJHyIpv4ImYsx8WCttmGK55YDVo5rTkyahnIb72pC/TKNZ1Nmoj/9TCV6KB4W6mXiMrO7+Jur\n" +
"j4wtp33QW6+wpAYCJWrKWC4ZPTGZtw0qPW/gU9IEmqvV1y15TVsbAoGBAPULY0PPvTWQz/WYj+Pb\n" +
"q9xqgV9VYIJb7g8GxPtqiu44ilwmUsE5ppEoE+8qPygBy8rgOqxk8RWyCYVeSzJfKn7o9wFOnMDD\n" +
"nFGLtFjaubrR+yEOugQo8JTJ7vwuQFideF1Jut3lxAj4EkiAA+k3QF2qr0pwgY/DdMsTVJHyyQvj\n" +
"AoGAWCkmZV8igZe2ti+HYDbAvTQNvzkj4A36RDBJ5MNeZzMk15IpNb7zL8i9f3qHowyuklA8AI2q\n" +
"8ph8fNS6RN8QDMiZUU/AOQC2fjYSjKsPEEiQSSbMrYYEU6AhhTGMR18zNS95qHI5ihHqKBamKG6k\n" +
"87J1iCgkE+1vppfNTnYxn50CgYEAjmaYv/6IQQmvoFSRQeQVgpiuJ/2QgRD1TewsKsLmi7t1xElN\n" +
"DBb5kh9NPk45t4EbsgEOd8KNS4NT/xol7tbY9jlh2XOaqnbCb60VGBG7nzKJktNhDCvSa1TSOeCS\n" +
"6ixQlz3Sh0MP4fpvfYxPOYcvM3+OMF8jG62FQMIyAkKpzOsCgYEAhQckFQP/qI1YYKjX/nNsf5ji\n" +
"k3Uy4qszmrg/TYjzBqmp99cVOcef2Jnygq3v6EL6tfMMfpdEWl/pyqkGrF1u73aGUKMg0+oMj+ic\n" +
"BzUk+DZ5OaYG1Yjrvr24d4BsKdq2qWDyh1wGjjWapqG6Xce600VvW5DDYpXuTiMqYLOb+HI=\n" +
"-----END RSA PRIVATE KEY-----\n";

        private const string CaKeyPairPkcs12Base64 =
"MIIKQgIBAzCCCf4GCSqGSIb3DQEHAaCCCe8EggnrMIIJ5zCCBZAGCSqGSIb3DQEHAaCCBYEEggV9" +
"MIIFeTCCBXUGCyqGSIb3DQEMCgECoIIE7jCCBOowHAYKKoZIhvcNAQwBAzAOBAgZD4EamJ/1QgIC" +
"B9AEggTIt+OCki8PJuGxHfHMFNhZNyob3LrDGkxpA+BDbnIJkMxGnBZYIYBY7HA0VivZOxjepfIn" +
"czwzd4EofN4Mx6MWQLwmIMaLcsbeH002ks2nT6R68u3OlR8udTgDxUuNqRKPPE3nmewo9P2m1F0u" +
"qitSolLJR8MFRPDYKoLh9UVj/llh1QDfxUAA4e6ZI1cLoyLAc9lNYrXFdKPvyrDri4kn74oYi0Qj" +
"rE7uDf8qhHfMNK58jDbJ6x56CsppNnvkBquwQsyTa1H7H/4hGSv8ntZ70NLf2JzItMBh8nTB9vHw" +
"no7IrdZByjQb+YuCnog1DH4HGGTHRyB2boSJUjTfFkxsx9bzKApbTQErTHnDxigEmVOKEUvjsf5U" +
"jY8ZUdhDylxQmimIECK7UXftjU0G2ZsVwopMyFPQexjbJF3+T42o5t2thLRFl0Kuwv+3bUfsBXYJ" +
"nC45/RQLFBcRojAZVlXJESh9VxTTU7ZVNgp2hAJ+1/jQlTilmE+4udYfX/JFTeBzEpUcJcf1uPXZ" +
"DQPfSqNhAgL0nWWJJwDU0ZBdjJoaTtyoIIZVbZxwZMYNuNXh2qieXbIcSQZ4YETltFRhTnd2WlHh" +
"aYm1Tyyv2z4Y5kIwk6BlLHpwEvq//Ugqh6yPmqQomGYW/ruznWQcryacXBJR6ip3ikfGGRuZGs5Z" +
"LEbqzjFIzhtlDI3u2+o3qJo+m+irBqKRc+s0BXy0hPNZ2kD+aYHF0Lu8VWj8n5pr7Bo35OVBO4BT" +
"X8rx4DBnc+6ZFpKtPjkIl3l/Aii4cTIw5pu+MRH2qiDoZKAMPHZRAiGYtuk5q1XkdxuZiI9Dvqa3" +
"Z0w9T/hTLwYW4WTc7+s+SEly1zjnBq7M4tGito71MoPsr24TcAuPFb/joW0kW/XHGz1UjuBx1Sg9" +
"7JyCefn7jD7MUOjp8A+SHAsrqcMBdn937CMDb8wMV5cHH1U09JCyXtt1duNwvJxfB0Z6OQtzg4vn" +
"hpnEgGsUxpqHX2lQL2H/N037fMtwmApKmRT4IlgZsqWouPH6rmWd1SUSVZ5JNmaj2yYD0dlzQCwl" +
"0a3f5hhYjdLU+TVOYVr17SCMI5rihjt8DWaDiKHtRk2MaoFE1gaBWJFf0mRv0GzD+wkNnpM0ZCBd" +
"Gg7WBOstSF/eouUN3MnMwIXABe3PRGD8jtGrYp7ZrdjKd+Ifbbbh0yc741yBSN5YT8RVscCyTzg9" +
"Ivdo+EulZFMAmebZuCe4S7BXkH7Td6dCeUtKMZfPcO67dmb1/AXU36DC06S+/S9KFOEGlAuFbpcV" +
"1568OpHXliHbHRLplDng+UA9hzUAXNmVCKXdtSd4WFukW/z4QwiuyFsZYnQJjRzkY/S4PFnvFMKL" +
"jcdeMbZ0wcSEKFALYv1gmxceDp7/CrjJ70KtZHqkanOJFP+iL5nPoifaJpcHdOWoHgrRJye+sMyd" +
"NjBXM7zqyqu0zofDwpJzuP8RFWSyMNFp7rVnapRA9mH88L8eEqqtyDisTku3ajdBtxmiIgdhhqGc" +
"hOHsw70o95MCuhFz6UoiRo4xr8jZnDy44e1EDa4EzjnEZi4A3BAv+paebEOZd1o+UinK0LBhDFpu" +
"LMY4+AUjYWT7Vlq1Efqr1uIHvuaXVoIZzifgd+Ai6To4MXQwEwYJKoZIhvcNAQkVMQYEBAEAAAAw" +
"XQYJKwYBBAGCNxEBMVAeTgBNAGkAYwByAG8AcwBvAGYAdAAgAFMAbwBmAHQAdwBhAHIAZQAgAEsA" +
"ZQB5ACAAUwB0AG8AcgBhAGcAZQAgAFAAcgBvAHYAaQBkAGUAcjCCBE8GCSqGSIb3DQEHBqCCBEAw" +
"ggQ8AgEAMIIENQYJKoZIhvcNAQcBMBwGCiqGSIb3DQEMAQMwDgQItWV14601/7sCAgfQgIIECA+1" +
"9iSPVyxBkNcwt0R/fWSOvkeQDeYSuEjXLfHCOJgNmML1TTtuPrn5hyi5fTJcyWh6J8HlPsNFZvYJ" +
"lJQF1wUmZdYDCFNRnLeukZyPDhfTecTKqForQnk9KZ4s0e+JZL2+4FjmaVd8+GoNrBN2z2bBVi7A" +
"KYiBUPiVN6UzpLzyYuSzeRnCrw1EpcvYLXlOM6Qa5rUqwSp1A62FXAKYVp5t6BjTBIlHDg+UW5zg" +
"48M326X9ZiEBd6lnrBcSUwbGk6mQGpW1S+uw4uOstj6qN+9Bhn7wzBQVGjgPGt8mXqnGELqluaHy" +
"R3+X9eciFMmM/Y8fog/bSnqg5pE34FTHvUp1xjJrNU2nqQfAsevGR2n1NfPlrZAjzNKnfTFeEXxk" +
"qjpes7Tjrc41P/nKoZZUrpM63yeFa51CEnGMlq3wvvI1RNRpKMk0A7GV2ta/ewNCWUIfITjFQNzY" +
"KWMUaHL20Ad+C9b/1+wnZEI6kH98KIjvds9fg67gzNjVH6qJLhIHYAZZuJj7QU2KbTiUmByMuh6y" +
"RPQhYA9mpWjqyg2DV7SAJ3EgFpBfgSNa4Wpp1ZBx2E2KLm3XKQuXlFB6gHOjsDgjG1jhVEaMwj98" +
"gv8RJ9dIzRhM0heJ38dZxiRu5HVLLEh8HetC9t4MKqjgDe3vPF+hD8iqwhwYH+vbSOG2PEfUx8Aa" +
"ZcKASVtOh1jZCZAkiIyA0LtXAVywVUNTC43IJttbzkJK3I0RUvRL+jDdw9pZbMiXr+ab0RdDDE/n" +
"Hc4L0u0LqcO0Se4EUuJ9Xy/ayllMosutzVy6a68BNI7+1syEL+O71JRLrGbwEmHxGQLmWN7hMjQI" +
"LlLlyIsEGmWwn8hHmkVJDlVMD8EsLdnuP+O9qSOw40/WlVt6u6kZxn7/Se7Bn8YFKVIDllS3ClXp" +
"gyP7XalMZdqTCB/OE+JNo9q6j+lLnY760OeAmKEQN+OWkayg2FLDRqo0lfWgNyS8BBdEJf7IhCHy" +
"42fi2kagUwihmlJGcPmHefZtSlP4zgIx7ZkKwY9d7mRrxg0xDnqz9noeeCEwQVZrNk5I47Dg/oLN" +
"SiM96Qna0QgxUCA2IJ6to2rTdL6H+gI93K0fWmFb44Y43eH10IgBGHtqvlTVtgh1YVMzE/qVXLEM" +
"+m4me2XAqAMlASe1vqkMk8YZbNgpSkvHbmvKSHF+7Dm2hTD5imDgNEL3QYCyG9qXLZ+ymzq52tx9" +
"OJVU2U8m88z0PmXSaE3CPVWqBE7ISTXlTvkGdYczk73CQxJZKSEMD9Z28GWoRgkd93NcC2Uza/27" +
"BnljRV1nJkvS97ii6pPyN7OsYh9hKTZssTCww+dn2MmoX6MLuKmiMI5IySGjX3eJIwgIdMz0QBSn" +
"Mz1ImTA7MB8wBwYFKw4DAhoEFBbxTH9CtToNlZioPLjOqq4ZouUvBBS0OyDZsrW10BEafOwev3sT" +
"eSILBgICB9A=";

        /* pwsh
           $cert2 = New-X509Certificate2 -SubjectName 'CN=Azure SDK' -SubjectAlternativeNames (New-X509Certificate2SubjectAlternativeNames -EmailAddress azuresdk@microsoft.com) -KeyUsageFlags KeyEncipherment, NonRepudiation, DigitalSignature -CA -TLS -ValidDays 3652

           $PemCertificateWithV3Extensions = ($cert2 | Format-X509Certificate2 -Type Certificate) + "`n" + ($cert2 | Format-X509Certificate2 -Type Pkcs8)
           $CertificateWithV3ExtensionsBase64 = $cert2 | Format-X509Certificate2 -Type CertificateBase64
         */

        // Expires: 2031-11-01T14:38:51.0000000-07:00
        private const string PemCertificateWithV3Extensions =
"-----BEGIN CERTIFICATE-----\n" +
"MIIDBjCCAe6gAwIBAgIJAIp6zuzS7TciMA0GCSqGSIb3DQEBCwUAMBQxEjAQBgNVBAMTCUF6dXJl\n" +
"IFNESzAeFw0yMTExMDEyMTM4NTFaFw0zMTExMDEyMTM4NTFaMBQxEjAQBgNVBAMTCUF6dXJlIFNE\n" +
"SzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJThmsquiv9NpJkzpugEu/6/GIUVmpy3\n" +
"CsjWmtfvFNL5UrGvI/YSZCEt4VRvI3TlcRxw+ewOSAIPSLMXwN6Qj5Edw07CKNhfXNtrdP7ATTox\n" +
"AUD/pOiw8/7NOs+tQ2UVEpbzHYTCHGZ7OiL/ffc6EptptLyiP83YAiTLXE1ayFMiKegqv52dPxja\n" +
"0gRXycBdqx5w5lARN/cYzbukFetO3At4Wjp8+pl/h2GkfK18SK1F+63jpkA0CaW+b6mwSZgJYZGR\n" +
"SGJjITJ8/T32RIP1wt01KmqElS6/kqsInwVuYHQkn8HJBJfu6qD3MfmzpYMMXwNqzc+2pERLnvIP\n" +
"zzXys+0CAwEAAaNbMFkwDwYDVR0TAQH/BAUwAwEB/zAhBgNVHREEGjAYgRZhenVyZXNka0BtaWNy\n" +
"b3NvZnQuY29tMA4GA1UdDwEB/wQEAwIF4DATBgNVHSUEDDAKBggrBgEFBQcDATANBgkqhkiG9w0B\n" +
"AQsFAAOCAQEAVNty5AeZZBBbPgVb1s8+GAPTTxo3xMVq2kv3zPkFbOgL8T8VRfb1Bs9gPGDm9pfQ\n" +
"H3h2n0SXB4hUcV8vOFLZsQo+Kms8LjK2oej0ReB33SSg/vo8lR9RA0cGjLn/Zpz6+PI+W4TM3ujb\n" +
"aw7HTnnAMYBtnOU7vJbXvIzJEg64pHJyJhipwT6uJz3S3FnGxT7iW6CdYNKxIW5+BW8YO8YIONFd\n" +
"b4HBw/bQfD/xfH4iDYTQqpmlce1UVh4NJ1oqAENQAmuyDt0RyCtxATrtXXTE9JAh8tV36zgRRDXB\n" +
"E4qx9fQ7+8qOLw+b/S0pbbPJtOGZAZtaaYJTRwz21AGxjKemNQ==\n" +
"-----END CERTIFICATE-----\n" +
"-----BEGIN PRIVATE KEY-----\n" +
"MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCU4ZrKror/TaSZM6boBLv+vxiF\n" +
"FZqctwrI1prX7xTS+VKxryP2EmQhLeFUbyN05XEccPnsDkgCD0izF8DekI+RHcNOwijYX1zba3T+\n" +
"wE06MQFA/6TosPP+zTrPrUNlFRKW8x2Ewhxmezoi/333OhKbabS8oj/N2AIky1xNWshTIinoKr+d\n" +
"nT8Y2tIEV8nAXasecOZQETf3GM27pBXrTtwLeFo6fPqZf4dhpHytfEitRfut46ZANAmlvm+psEmY\n" +
"CWGRkUhiYyEyfP099kSD9cLdNSpqhJUuv5KrCJ8FbmB0JJ/ByQSX7uqg9zH5s6WDDF8Das3PtqRE\n" +
"S57yD8818rPtAgMBAAECggEAMcC25tavcqPyxpPBSjYS0Q3xVsAifA6bVwSImHK4JczV+rUJsnjw\n" +
"5zma3ImLcsweIaALlPwsyitrYxYkCPyMTbWBiDdQSQaNVHIzldKTvEeWIK+N34kK8PKKnc5MAGKr\n" +
"ZLB4A96OeRzjD8ELymuovjD0Cjm6UsLF7J/dB6i32zfEA67wVMi7q65xNxnoSMqAyIVuTL9/T/Gg\n" +
"9IZ/qv+AbalSxTbZcACx2p9TtNNW9fUjOoNQ5mFrVch4Li2jCfuXeiGduvvJuFi1YEGR8RXVMjTb\n" +
"K3XGL9LAy4b7nlk9HX0bdnpqUuFjPxmT2PF6zaLx1iYEQ7C3Kg6osJwq5koLTQKBgQDANIxqOG+b\n" +
"JPbLQRFmsCm9lc/WSN0/6GPvgTQk67zLgLz4KssLhSBq6K6b5egMgQB8Mf9E3VrPEz+6FGv9A5uN\n" +
"jS3RJjvr/vUBppafVChfJ2j8Ym+M2lERsxXnHEUalOPV2xIBY7P6CJkd8AFvJ0g7qodiHiWKtd17\n" +
"vrYHKSE1RwKBgQDGS94nt86Ln4S6PZA+uc/sDIZg+Nzup4RcLNB3c18DkLU6x7UJGdclmQ5lzFj8\n" +
"dvB+YKmCjR+xdVVRsXxwTkO1HWDiVX0gCu4uwRqVpPmhAbGDTIKP8C0VygZXq/KiH+P0mxm0ar0/\n" +
"NZ8F1Gb/L2jUfgyelEBItlmgVukDFe+3KwKBgHkxqUhhBZ6iFCvdf4dslSVCDadkkn31nu4qXiLZ\n" +
"slXvezhQY2+EJgjDZzZOJZ+cyB2HuRpHKTdhP9Gpht4nJDKBTt6OaUJJpVvBG0Cj5ED7rKtXtlbu\n" +
"Yify8GCl5rz4HSF/3T6bC6UhPsstxvm7n0RgJrWrpKhuPJYGjui8+n+JAoGAPXuIhggXonLzVEuC\n" +
"TfCO50F66NZAqj6Ga435lQ/Qhep4RqFlIE1CyAWM0UNq09yM9KJD7JaVHRCkQ5AkZS3fEGjrgUHA\n" +
"ag75isWU2JEuVR2RTISMdtShJgBdtxE5SctZgp4UejweMVsO01/oD3dDqZ7rir+srt7bKzvHQ42p\n" +
"pcECgYBO8pp9l3P18f7Pr1B9/A+yD+55g1p4xYxxFZIk0XRDM0M74m8VN1xkiPcsk/qKtX/aHxZW\n" +
"BQ1nsjz+ehwp5gqrflywQM6o5jevUH3WGujKDZvVKE0M79MbrEwurZz57DRSx35146ngbYcM4iAX\n" +
"r+jbJ/mZF13/0dsQIUuD1Cn3Qw==\n" +
"-----END PRIVATE KEY-----\n";

        private const string CertificateWithV3ExtensionsBase64 =
"MIIDBjCCAe6gAwIBAgIJAIp6zuzS7TciMA0GCSqGSIb3DQEBCwUAMBQxEjAQBgNVBAMTCUF6dXJl" +
"IFNESzAeFw0yMTExMDEyMTM4NTFaFw0zMTExMDEyMTM4NTFaMBQxEjAQBgNVBAMTCUF6dXJlIFNE" +
"SzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJThmsquiv9NpJkzpugEu/6/GIUVmpy3" +
"CsjWmtfvFNL5UrGvI/YSZCEt4VRvI3TlcRxw+ewOSAIPSLMXwN6Qj5Edw07CKNhfXNtrdP7ATTox" +
"AUD/pOiw8/7NOs+tQ2UVEpbzHYTCHGZ7OiL/ffc6EptptLyiP83YAiTLXE1ayFMiKegqv52dPxja" +
"0gRXycBdqx5w5lARN/cYzbukFetO3At4Wjp8+pl/h2GkfK18SK1F+63jpkA0CaW+b6mwSZgJYZGR" +
"SGJjITJ8/T32RIP1wt01KmqElS6/kqsInwVuYHQkn8HJBJfu6qD3MfmzpYMMXwNqzc+2pERLnvIP" +
"zzXys+0CAwEAAaNbMFkwDwYDVR0TAQH/BAUwAwEB/zAhBgNVHREEGjAYgRZhenVyZXNka0BtaWNy" +
"b3NvZnQuY29tMA4GA1UdDwEB/wQEAwIF4DATBgNVHSUEDDAKBggrBgEFBQcDATANBgkqhkiG9w0B" +
"AQsFAAOCAQEAVNty5AeZZBBbPgVb1s8+GAPTTxo3xMVq2kv3zPkFbOgL8T8VRfb1Bs9gPGDm9pfQ" +
"H3h2n0SXB4hUcV8vOFLZsQo+Kms8LjK2oej0ReB33SSg/vo8lR9RA0cGjLn/Zpz6+PI+W4TM3ujb" +
"aw7HTnnAMYBtnOU7vJbXvIzJEg64pHJyJhipwT6uJz3S3FnGxT7iW6CdYNKxIW5+BW8YO8YIONFd" +
"b4HBw/bQfD/xfH4iDYTQqpmlce1UVh4NJ1oqAENQAmuyDt0RyCtxATrtXXTE9JAh8tV36zgRRDXB" +
"E4qx9fQ7+8qOLw+b/S0pbbPJtOGZAZtaaYJTRwz21AGxjKemNQ==";
    }
}
