// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Security.KeyVault.Administration.Models
{
    /// <summary> The RestoreOperationParameters. </summary>
    internal partial class RestoreOperationParameters
    {
        /// <summary> Initializes a new instance of <see cref="RestoreOperationParameters"/>. </summary>
        /// <param name="sasTokenParameters"></param>
        /// <param name="folderToRestore"> The Folder name of the blob where the previous successful full backup was stored. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sasTokenParameters"/> or <paramref name="folderToRestore"/> is null. </exception>
        public RestoreOperationParameters(SASTokenParameter sasTokenParameters, string folderToRestore)
        {
            Argument.AssertNotNull(sasTokenParameters, nameof(sasTokenParameters));
            Argument.AssertNotNull(folderToRestore, nameof(folderToRestore));

            SasTokenParameters = sasTokenParameters;
            FolderToRestore = folderToRestore;
        }

        /// <summary> Gets the sas token parameters. </summary>
        public SASTokenParameter SasTokenParameters { get; }
        /// <summary> The Folder name of the blob where the previous successful full backup was stored. </summary>
        public string FolderToRestore { get; }
    }
}
