// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Security.KeyVault.Administration
{
    /// <summary> The type specifier of the value. </summary>
    public readonly partial struct KeyVaultSettingType : IEquatable<KeyVaultSettingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultSettingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultSettingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BooleanValue = "boolean";

        /// <summary> boolean. </summary>
        public static KeyVaultSettingType Boolean { get; } = new KeyVaultSettingType(BooleanValue);
        /// <summary> Determines if two <see cref="KeyVaultSettingType"/> values are the same. </summary>
        public static bool operator ==(KeyVaultSettingType left, KeyVaultSettingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultSettingType"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultSettingType left, KeyVaultSettingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultSettingType"/>. </summary>
        public static implicit operator KeyVaultSettingType(string value) => new KeyVaultSettingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultSettingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultSettingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
