// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Security.KeyVault.Administration
{
    /// <summary> The role type. </summary>
    public readonly partial struct KeyVaultRoleType : IEquatable<KeyVaultRoleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultRoleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultRoleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BuiltInRoleValue = "AKVBuiltInRole";
        private const string CustomRoleValue = "CustomRole";

        /// <summary> Built in role. </summary>
        public static KeyVaultRoleType BuiltInRole { get; } = new KeyVaultRoleType(BuiltInRoleValue);
        /// <summary> Custom role. </summary>
        public static KeyVaultRoleType CustomRole { get; } = new KeyVaultRoleType(CustomRoleValue);
        /// <summary> Determines if two <see cref="KeyVaultRoleType"/> values are the same. </summary>
        public static bool operator ==(KeyVaultRoleType left, KeyVaultRoleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultRoleType"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultRoleType left, KeyVaultRoleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultRoleType"/>. </summary>
        public static implicit operator KeyVaultRoleType(string value) => new KeyVaultRoleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultRoleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultRoleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
