// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Security.KeyVault.Administration
{
    /// <summary> Role Assignments. </summary>
    public partial class KeyVaultRoleAssignment
    {
        /// <summary> Initializes a new instance of <see cref="KeyVaultRoleAssignment"/>. </summary>
        internal KeyVaultRoleAssignment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultRoleAssignment"/>. </summary>
        /// <param name="id"> The role assignment ID. </param>
        /// <param name="name"> The role assignment name. </param>
        /// <param name="type"> The role assignment type. </param>
        /// <param name="properties"> Role assignment properties. </param>
        internal KeyVaultRoleAssignment(string id, string name, string type, KeyVaultRoleAssignmentProperties properties)
        {
            Id = id;
            Name = name;
            Type = type;
            Properties = properties;
        }

        /// <summary> The role assignment ID. </summary>
        public string Id { get; }
        /// <summary> The role assignment name. </summary>
        public string Name { get; }
        /// <summary> The role assignment type. </summary>
        public string Type { get; }
        /// <summary> Role assignment properties. </summary>
        public KeyVaultRoleAssignmentProperties Properties { get; }
    }
}
