// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Security.KeyVault.Administration
{
    /// <summary> Role definition permissions. </summary>
    public partial class KeyVaultPermission
    {
        /// <summary> Initializes a new instance of <see cref="KeyVaultPermission"/>. </summary>
        public KeyVaultPermission()
        {
            Actions = new ChangeTrackingList<string>();
            NotActions = new ChangeTrackingList<string>();
            DataActions = new ChangeTrackingList<KeyVaultDataAction>();
            NotDataActions = new ChangeTrackingList<KeyVaultDataAction>();
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultPermission"/>. </summary>
        /// <param name="actions"> Action permissions that are granted. </param>
        /// <param name="notActions"> Action permissions that are excluded but not denied. They may be granted by other role definitions assigned to a principal. </param>
        /// <param name="dataActions"> Data action permissions that are granted. </param>
        /// <param name="notDataActions"> Data action permissions that are excluded but not denied. They may be granted by other role definitions assigned to a principal. </param>
        internal KeyVaultPermission(IList<string> actions, IList<string> notActions, IList<KeyVaultDataAction> dataActions, IList<KeyVaultDataAction> notDataActions)
        {
            Actions = actions;
            NotActions = notActions;
            DataActions = dataActions;
            NotDataActions = notDataActions;
        }

        /// <summary> Action permissions that are granted. </summary>
        public IList<string> Actions { get; }
        /// <summary> Action permissions that are excluded but not denied. They may be granted by other role definitions assigned to a principal. </summary>
        public IList<string> NotActions { get; }
        /// <summary> Data action permissions that are granted. </summary>
        public IList<KeyVaultDataAction> DataActions { get; }
        /// <summary> Data action permissions that are excluded but not denied. They may be granted by other role definitions assigned to a principal. </summary>
        public IList<KeyVaultDataAction> NotDataActions { get; }
    }
}
