// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Security.KeyVault.Administration
{
    public partial class GetSettingsResult
    {
        internal static GetSettingsResult DeserializeGetSettingsResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<KeyVaultSetting> settings = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("settings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<KeyVaultSetting> array = new List<KeyVaultSetting>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(KeyVaultSetting.DeserializeKeyVaultSetting(item));
                    }
                    settings = array;
                    continue;
                }
            }
            return new GetSettingsResult(settings ?? new ChangeTrackingList<KeyVaultSetting>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static GetSettingsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGetSettingsResult(document.RootElement);
        }
    }
}
