// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> SKU details. </summary>
    public partial class ManagedHsmSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmSku"/>. </summary>
        /// <param name="family"> SKU Family of the managed HSM Pool. </param>
        /// <param name="name"> SKU of the managed HSM Pool. </param>
        public ManagedHsmSku(ManagedHsmSkuFamily family, ManagedHsmSkuName name)
        {
            Family = family;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedHsmSku"/>. </summary>
        /// <param name="family"> SKU Family of the managed HSM Pool. </param>
        /// <param name="name"> SKU of the managed HSM Pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedHsmSku(ManagedHsmSkuFamily family, ManagedHsmSkuName name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Family = family;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedHsmSku"/> for deserialization. </summary>
        internal ManagedHsmSku()
        {
        }

        /// <summary> SKU Family of the managed HSM Pool. </summary>
        [WirePath("family")]
        public ManagedHsmSkuFamily Family { get; set; }
        /// <summary> SKU of the managed HSM Pool. </summary>
        [WirePath("name")]
        public ManagedHsmSkuName Name { get; set; }
    }
}
