// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> Provisioning state. </summary>
    public readonly partial struct ManagedHsmProvisioningState : IEquatable<ManagedHsmProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string ProvisioningValue = "Provisioning";
        private const string FailedValue = "Failed";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string ActivatedValue = "Activated";
        private const string SecurityDomainRestoreValue = "SecurityDomainRestore";
        private const string RestoringValue = "Restoring";

        /// <summary> The managed HSM Pool has been full provisioned. </summary>
        public static ManagedHsmProvisioningState Succeeded { get; } = new ManagedHsmProvisioningState(SucceededValue);
        /// <summary> The managed HSM Pool is currently being provisioned. </summary>
        public static ManagedHsmProvisioningState Provisioning { get; } = new ManagedHsmProvisioningState(ProvisioningValue);
        /// <summary> Provisioning of the managed HSM Pool has failed. </summary>
        public static ManagedHsmProvisioningState Failed { get; } = new ManagedHsmProvisioningState(FailedValue);
        /// <summary> The managed HSM Pool is currently being updated. </summary>
        public static ManagedHsmProvisioningState Updating { get; } = new ManagedHsmProvisioningState(UpdatingValue);
        /// <summary> The managed HSM Pool is currently being deleted. </summary>
        public static ManagedHsmProvisioningState Deleting { get; } = new ManagedHsmProvisioningState(DeletingValue);
        /// <summary> The managed HSM pool is ready for normal use. </summary>
        public static ManagedHsmProvisioningState Activated { get; } = new ManagedHsmProvisioningState(ActivatedValue);
        /// <summary> The managed HSM pool is waiting for a security domain restore action. </summary>
        public static ManagedHsmProvisioningState SecurityDomainRestore { get; } = new ManagedHsmProvisioningState(SecurityDomainRestoreValue);
        /// <summary> The managed HSM pool is being restored from full HSM backup. </summary>
        public static ManagedHsmProvisioningState Restoring { get; } = new ManagedHsmProvisioningState(RestoringValue);
        /// <summary> Determines if two <see cref="ManagedHsmProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmProvisioningState left, ManagedHsmProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmProvisioningState left, ManagedHsmProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmProvisioningState"/>. </summary>
        public static implicit operator ManagedHsmProvisioningState(string value) => new ManagedHsmProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
