// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> Properties of the managed HSM Pool. </summary>
    public partial class ManagedHsmProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmProperties"/>. </summary>
        public ManagedHsmProperties()
        {
            InitialAdminObjectIds = new ChangeTrackingList<string>();
            Regions = new ChangeTrackingList<ManagedHsmGeoReplicatedRegion>();
            PrivateEndpointConnections = new ChangeTrackingList<ManagedHsmPrivateEndpointConnectionItemData>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedHsmProperties"/>. </summary>
        /// <param name="tenantId"> The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool. </param>
        /// <param name="initialAdminObjectIds"> Array of initial administrators object ids for this managed hsm pool. </param>
        /// <param name="hsmUri"> The URI of the managed hsm pool for performing operations on keys. </param>
        /// <param name="enableSoftDelete"> Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable. </param>
        /// <param name="softDeleteRetentionInDays"> Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90. </param>
        /// <param name="enablePurgeProtection"> Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible. </param>
        /// <param name="createMode"> The create mode to indicate whether the resource is being created or is being recovered from a deleted resource. </param>
        /// <param name="statusMessage"> Resource Status Message. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="networkRuleSet"> Rules governing the accessibility of the key vault from specific network locations. </param>
        /// <param name="regions"> List of all regions associated with the managed hsm pool. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the managed hsm pool. </param>
        /// <param name="publicNetworkAccess"> Control permission to the managed HSM from public networks. </param>
        /// <param name="scheduledPurgeOn"> The scheduled purge date in UTC. </param>
        /// <param name="securityDomainProperties"> Managed HSM security domain properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedHsmProperties(Guid? tenantId, IList<string> initialAdminObjectIds, Uri hsmUri, bool? enableSoftDelete, int? softDeleteRetentionInDays, bool? enablePurgeProtection, ManagedHsmCreateMode? createMode, string statusMessage, ManagedHsmProvisioningState? provisioningState, ManagedHsmNetworkRuleSet networkRuleSet, IList<ManagedHsmGeoReplicatedRegion> regions, IReadOnlyList<ManagedHsmPrivateEndpointConnectionItemData> privateEndpointConnections, ManagedHsmPublicNetworkAccess? publicNetworkAccess, DateTimeOffset? scheduledPurgeOn, ManagedHSMSecurityDomainProperties securityDomainProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            InitialAdminObjectIds = initialAdminObjectIds;
            HsmUri = hsmUri;
            EnableSoftDelete = enableSoftDelete;
            SoftDeleteRetentionInDays = softDeleteRetentionInDays;
            EnablePurgeProtection = enablePurgeProtection;
            CreateMode = createMode;
            StatusMessage = statusMessage;
            ProvisioningState = provisioningState;
            NetworkRuleSet = networkRuleSet;
            Regions = regions;
            PrivateEndpointConnections = privateEndpointConnections;
            PublicNetworkAccess = publicNetworkAccess;
            ScheduledPurgeOn = scheduledPurgeOn;
            SecurityDomainProperties = securityDomainProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> Array of initial administrators object ids for this managed hsm pool. </summary>
        [WirePath("initialAdminObjectIds")]
        public IList<string> InitialAdminObjectIds { get; }
        /// <summary> The URI of the managed hsm pool for performing operations on keys. </summary>
        [WirePath("hsmUri")]
        public Uri HsmUri { get; }
        /// <summary> Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. Soft delete is enabled by default for all managed HSMs and is immutable. </summary>
        [WirePath("enableSoftDelete")]
        public bool? EnableSoftDelete { get; set; }
        /// <summary> Soft deleted data retention days. When you delete an HSM or a key, it will remain recoverable for the configured retention period or for a default period of 90 days. It accepts values between 7 and 90. </summary>
        [WirePath("softDeleteRetentionInDays")]
        public int? SoftDeleteRetentionInDays { get; set; }
        /// <summary> Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. Enabling this functionality is irreversible. </summary>
        [WirePath("enablePurgeProtection")]
        public bool? EnablePurgeProtection { get; set; }
        /// <summary> The create mode to indicate whether the resource is being created or is being recovered from a deleted resource. </summary>
        [WirePath("createMode")]
        public ManagedHsmCreateMode? CreateMode { get; set; }
        /// <summary> Resource Status Message. </summary>
        [WirePath("statusMessage")]
        public string StatusMessage { get; }
        /// <summary> Provisioning state. </summary>
        [WirePath("provisioningState")]
        public ManagedHsmProvisioningState? ProvisioningState { get; }
        /// <summary> Rules governing the accessibility of the key vault from specific network locations. </summary>
        [WirePath("networkAcls")]
        public ManagedHsmNetworkRuleSet NetworkRuleSet { get; set; }
        /// <summary> List of all regions associated with the managed hsm pool. </summary>
        [WirePath("regions")]
        public IList<ManagedHsmGeoReplicatedRegion> Regions { get; }
        /// <summary> List of private endpoint connections associated with the managed hsm pool. </summary>
        [WirePath("privateEndpointConnections")]
        public IReadOnlyList<ManagedHsmPrivateEndpointConnectionItemData> PrivateEndpointConnections { get; }
        /// <summary> Control permission to the managed HSM from public networks. </summary>
        [WirePath("publicNetworkAccess")]
        public ManagedHsmPublicNetworkAccess? PublicNetworkAccess { get; set; }
        /// <summary> The scheduled purge date in UTC. </summary>
        [WirePath("scheduledPurgeDate")]
        public DateTimeOffset? ScheduledPurgeOn { get; }
        /// <summary> Managed HSM security domain properties. </summary>
        [WirePath("securityDomainProperties")]
        public ManagedHSMSecurityDomainProperties SecurityDomainProperties { get; }
    }
}
