// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct ManagedHsmPrivateEndpointServiceConnectionStatus : IEquatable<ManagedHsmPrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmPrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmPrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static ManagedHsmPrivateEndpointServiceConnectionStatus Pending { get; } = new ManagedHsmPrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static ManagedHsmPrivateEndpointServiceConnectionStatus Approved { get; } = new ManagedHsmPrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static ManagedHsmPrivateEndpointServiceConnectionStatus Rejected { get; } = new ManagedHsmPrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static ManagedHsmPrivateEndpointServiceConnectionStatus Disconnected { get; } = new ManagedHsmPrivateEndpointServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="ManagedHsmPrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmPrivateEndpointServiceConnectionStatus left, ManagedHsmPrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmPrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmPrivateEndpointServiceConnectionStatus left, ManagedHsmPrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmPrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator ManagedHsmPrivateEndpointServiceConnectionStatus(string value) => new ManagedHsmPrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmPrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmPrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
