// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct ManagedHsmPrivateEndpointConnectionProvisioningState : IEquatable<ManagedHsmPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Succeeded. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Succeeded { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Creating { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Updating { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Deleting { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Failed { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Disconnected. </summary>
        public static ManagedHsmPrivateEndpointConnectionProvisioningState Disconnected { get; } = new ManagedHsmPrivateEndpointConnectionProvisioningState(DisconnectedValue);
        /// <summary> Determines if two <see cref="ManagedHsmPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmPrivateEndpointConnectionProvisioningState left, ManagedHsmPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmPrivateEndpointConnectionProvisioningState left, ManagedHsmPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator ManagedHsmPrivateEndpointConnectionProvisioningState(string value) => new ManagedHsmPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
