// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. </summary>
    public readonly partial struct ManagedHsmNetworkRuleAction : IEquatable<ManagedHsmNetworkRuleAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmNetworkRuleAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmNetworkRuleAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static ManagedHsmNetworkRuleAction Allow { get; } = new ManagedHsmNetworkRuleAction(AllowValue);
        /// <summary> Deny. </summary>
        public static ManagedHsmNetworkRuleAction Deny { get; } = new ManagedHsmNetworkRuleAction(DenyValue);
        /// <summary> Determines if two <see cref="ManagedHsmNetworkRuleAction"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmNetworkRuleAction left, ManagedHsmNetworkRuleAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmNetworkRuleAction"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmNetworkRuleAction left, ManagedHsmNetworkRuleAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmNetworkRuleAction"/>. </summary>
        public static implicit operator ManagedHsmNetworkRuleAction(string value) => new ManagedHsmNetworkRuleAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmNetworkRuleAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmNetworkRuleAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
