// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> The reason that a managed hsm name could not be used. The reason element is only returned if NameAvailable is false. </summary>
    public readonly partial struct ManagedHsmNameUnavailableReason : IEquatable<ManagedHsmNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccountNameInvalidValue = "AccountNameInvalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> AccountNameInvalid. </summary>
        public static ManagedHsmNameUnavailableReason AccountNameInvalid { get; } = new ManagedHsmNameUnavailableReason(AccountNameInvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static ManagedHsmNameUnavailableReason AlreadyExists { get; } = new ManagedHsmNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="ManagedHsmNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmNameUnavailableReason left, ManagedHsmNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmNameUnavailableReason left, ManagedHsmNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmNameUnavailableReason"/>. </summary>
        public static implicit operator ManagedHsmNameUnavailableReason(string value) => new ManagedHsmNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
