// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> A region that this managed HSM Pool has been extended to. </summary>
    public partial class ManagedHsmGeoReplicatedRegion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmGeoReplicatedRegion"/>. </summary>
        public ManagedHsmGeoReplicatedRegion()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedHsmGeoReplicatedRegion"/>. </summary>
        /// <param name="name"> Name of the geo replicated region. </param>
        /// <param name="provisioningState"> Provisioning state of the geo replicated region. </param>
        /// <param name="isPrimary"> A boolean value that indicates whether the region is the primary region or a secondary region. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedHsmGeoReplicatedRegion(string name, ManagedHsmGeoReplicatedRegionProvisioningState? provisioningState, bool? isPrimary, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ProvisioningState = provisioningState;
            IsPrimary = isPrimary;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the geo replicated region. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Provisioning state of the geo replicated region. </summary>
        [WirePath("provisioningState")]
        public ManagedHsmGeoReplicatedRegionProvisioningState? ProvisioningState { get; }
        /// <summary> A boolean value that indicates whether the region is the primary region or a secondary region. </summary>
        [WirePath("isPrimary")]
        public bool? IsPrimary { get; set; }
    }
}
