// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.KeyVault.Models
{
    internal static partial class ManagedHsmCreateModeExtensions
    {
        public static string ToSerialString(this ManagedHsmCreateMode value) => value switch
        {
            ManagedHsmCreateMode.Default => "default",
            ManagedHsmCreateMode.Recover => "recover",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ManagedHsmCreateMode value.")
        };

        public static ManagedHsmCreateMode ToManagedHsmCreateMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "default")) return ManagedHsmCreateMode.Default;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "recover")) return ManagedHsmCreateMode.Recover;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ManagedHsmCreateMode value.");
        }
    }
}
