// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> A message indicating if changes on the service provider require any updates on the consumer. </summary>
    public readonly partial struct ManagedHsmActionsRequiredMessage : IEquatable<ManagedHsmActionsRequiredMessage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHsmActionsRequiredMessage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHsmActionsRequiredMessage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";

        /// <summary> None. </summary>
        public static ManagedHsmActionsRequiredMessage None { get; } = new ManagedHsmActionsRequiredMessage(NoneValue);
        /// <summary> Determines if two <see cref="ManagedHsmActionsRequiredMessage"/> values are the same. </summary>
        public static bool operator ==(ManagedHsmActionsRequiredMessage left, ManagedHsmActionsRequiredMessage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHsmActionsRequiredMessage"/> values are not the same. </summary>
        public static bool operator !=(ManagedHsmActionsRequiredMessage left, ManagedHsmActionsRequiredMessage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHsmActionsRequiredMessage"/>. </summary>
        public static implicit operator ManagedHsmActionsRequiredMessage(string value) => new ManagedHsmActionsRequiredMessage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHsmActionsRequiredMessage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHsmActionsRequiredMessage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
