// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> Activation Status. </summary>
    public readonly partial struct ManagedHSMSecurityDomainActivationStatus : IEquatable<ManagedHSMSecurityDomainActivationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedHSMSecurityDomainActivationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedHSMSecurityDomainActivationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string NotActivatedValue = "NotActivated";
        private const string UnknownValue = "Unknown";
        private const string FailedValue = "Failed";

        /// <summary> The managed HSM Pool is active. </summary>
        public static ManagedHSMSecurityDomainActivationStatus Active { get; } = new ManagedHSMSecurityDomainActivationStatus(ActiveValue);
        /// <summary> The managed HSM Pool is not yet activated. </summary>
        public static ManagedHSMSecurityDomainActivationStatus NotActivated { get; } = new ManagedHSMSecurityDomainActivationStatus(NotActivatedValue);
        /// <summary> An unknown error occurred while activating managed hsm. </summary>
        public static ManagedHSMSecurityDomainActivationStatus Unknown { get; } = new ManagedHSMSecurityDomainActivationStatus(UnknownValue);
        /// <summary> Failed to activate managed hsm. </summary>
        public static ManagedHSMSecurityDomainActivationStatus Failed { get; } = new ManagedHSMSecurityDomainActivationStatus(FailedValue);
        /// <summary> Determines if two <see cref="ManagedHSMSecurityDomainActivationStatus"/> values are the same. </summary>
        public static bool operator ==(ManagedHSMSecurityDomainActivationStatus left, ManagedHSMSecurityDomainActivationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedHSMSecurityDomainActivationStatus"/> values are not the same. </summary>
        public static bool operator !=(ManagedHSMSecurityDomainActivationStatus left, ManagedHSMSecurityDomainActivationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedHSMSecurityDomainActivationStatus"/>. </summary>
        public static implicit operator ManagedHSMSecurityDomainActivationStatus(string value) => new ManagedHSMSecurityDomainActivationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedHSMSecurityDomainActivationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedHSMSecurityDomainActivationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
