// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.KeyVault.Models
{
    /// <summary> Provisioning state of the vault. </summary>
    public readonly partial struct KeyVaultProvisioningState : IEquatable<KeyVaultProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KeyVaultProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KeyVaultProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string RegisteringDnsValue = "RegisteringDns";

        /// <summary> Succeeded. </summary>
        public static KeyVaultProvisioningState Succeeded { get; } = new KeyVaultProvisioningState(SucceededValue);
        /// <summary> RegisteringDns. </summary>
        public static KeyVaultProvisioningState RegisteringDns { get; } = new KeyVaultProvisioningState(RegisteringDnsValue);
        /// <summary> Determines if two <see cref="KeyVaultProvisioningState"/> values are the same. </summary>
        public static bool operator ==(KeyVaultProvisioningState left, KeyVaultProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KeyVaultProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(KeyVaultProvisioningState left, KeyVaultProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KeyVaultProvisioningState"/>. </summary>
        public static implicit operator KeyVaultProvisioningState(string value) => new KeyVaultProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KeyVaultProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KeyVaultProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
